# Copyright 2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
""" Test Dropout """
import numpy as np
import pytest

import mindspore.nn as nn
from mindspore import Tensor
from mindspore import context

context.set_context(device_target="Ascend")


def test_check_dropout_3():
    Tensor(np.ones([20, 16, 50]).astype(np.int32))
    with pytest.raises(ValueError):
        nn.Dropout(3)


class Net_dropout(nn.Cell):
    def __init__(self):
        super(Net_dropout, self).__init__()
        self.dropout = nn.Dropout(0.5)

    def construct(self, x):
        return self.dropout(x)
