/**
 * Copyright 2019 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef TESTS_MINDRECORD_CONFIGURATION_H_
#define TESTS_MINDRECORD_CONFIGURATION_H_

// schema define
const char kCvatSchema[] =
  "{            "
  "\"name\": {                         "
  "   \"type\": \"string\"             "
  "},                                  "
  "\"anno_tool\": {                    "
  "   \"type\": \"string\"             "
  "},                                  "
  "\"creation_time\": {                "
  "   \"type\": \"string\"             "
  "},                                  "
  "\"max_shape_id\": {                 "
  "   \"type\": \"int32\"             "
  "},                                  "
  "\"max_entity_id\": {                "
  "   \"type\": \"int32\"             "
  "},                                  "
  "\"entity_instances\": {             "
  "   \"type\": \"bytes\"              "
  "   }                                "
  "}";

const char kCvatSchemaDesc[] = "annotate CVAT";

// image schema
const char kImageSchema[] =
  "{ "
  "\"name\": {                "
  "  \"type\": \"string\"     "
  "},                         "
  "\"type\": {                "
  "  \"type\": \"string\"     "
  "},                         "
  "\"id\": {                  "
  "  \"type\": \"string\"     "
  "},                         "
  "\"size\": {                "
  "  \"type\": \"int32\"      "
  "},                         "
  "\"width\": {               "
  "  \"type\": \"int32\"      "
  "},                         "
  "\"height\": {              "
  "  \"type\": \"int32\"      "
  "}                          "
  "}";

const char kImageSchemaDesc[] = "image schema";

const std::array<std::string, 5> kStatistics = {
  "{\"level\": ["
  "{\"key\": \"2019-03-30\", \"count\": 24}, {\"key\": \"2019-03-31\", \"count\": 23}, "
  "{\"key\": \"2019-04-01\", \"count\": 28}, {\"key\": \"2019-04-02\", \"count\": 22}, "
  "{\"key\": \"2019-04-03\", \"count\": 24}, {\"key\": \"2019-04-04\", \"count\": 32}, "
  "{\"key\": \"2019-04-05\", \"count\": 27}, {\"key\": \"2019-04-06\", \"count\": 24}, "
  "{\"key\": \"2019-04-07\", \"count\": 22}, {\"key\": \"2019-04-08\", \"count\": 29}, "
  "{\"key\": \"2019-04-09\", \"count\": 18}, {\"key\": \"2019-04-10\", \"count\": 24}, "
  "{\"key\": \"2019-04-11\", \"count\": 22}, {\"key\": \"2019-04-12\", \"count\": 23}, "
  "{\"key\": \"2019-04-13\", \"count\": 27}, {\"key\": \"2019-04-14\", \"count\": 28}, "
  "{\"key\": \"2019-04-15\", \"count\": 21}, {\"key\": \"2019-04-16\", \"count\": 27}, "
  "{\"key\": \"2019-04-17\", \"count\": 25}, {\"key\": \"2019-04-18\", \"count\": 23}, "
  "{\"key\": \"2019-04-19\", \"count\": 31}, {\"key\": \"2019-04-20\", \"count\": 28}, "
  "{\"key\": \"2019-04-21\", \"count\": 29}, {\"key\": \"2019-04-22\", \"count\": 30}, "
  "{\"key\": \"2019-04-23\", \"count\": 21}, {\"key\": \"2019-04-24\", \"count\": 32}, "
  "{\"key\": \"2019-04-25\", \"count\": 28}, {\"key\": \"2019-04-26\", \"count\": 21}, "
  "{\"key\": \"2019-04-27\", \"count\": 32}, {\"key\": \"2019-04-28\", \"count\": 22}, "
  "{\"key\": \"2019-04-29\", \"count\": 30}, {\"key\": \"2019-04-30\", \"count\": 23}, "
  "{\"key\": \"2019-05-01\", \"count\": 36}, {\"key\": \"2019-05-02\", \"count\": 31}, "
  "{\"key\": \"2019-05-03\", \"count\": 31}, {\"key\": \"2019-05-04\", \"count\": 18}, "
  "{\"key\": \"2019-05-05\", \"count\": 28}, {\"key\": \"2019-05-06\", \"count\": 28}, "
  "{\"key\": \"2019-05-07\", \"count\": 35}, {\"key\": \"2019-05-08\", \"count\": 20}, "
  "{\"key\": \"2019-05-09\", \"count\": 25}, {\"key\": \"2019-05-10\", \"count\": 33}, "
  "{\"key\": \"2019-05-11\", \"count\": 16}, {\"key\": \"2019-05-12\", \"count\": 21}, "
  "{\"key\": \"2019-05-13\", \"count\": 18}, {\"key\": \"2019-05-14\", \"count\": 38}, "
  "{\"key\": \"2019-05-15\", \"count\": 23}, {\"key\": \"2019-05-16\", \"count\": 31}"
  "]}",
  "{\"level\": ["
  "{\"key\": \"2018-12-31\", \"count\": 192}, {\"key\": \"2019-01-07\", \"count\": 182}, "
  "{\"key\": \"2019-01-14\", \"count\": 169}, {\"key\": \"2019-01-21\", \"count\": 179}, "
  "{\"key\": \"2019-01-28\", \"count\": 192}, {\"key\": \"2019-02-04\", \"count\": 166}, "
  "{\"key\": \"2019-02-11\", \"count\": 211}, {\"key\": \"2019-02-18\", \"count\": 180}, "
  "{\"key\": \"2019-02-25\", \"count\": 203}, {\"key\": \"2019-03-04\", \"count\": 185}, "
  "{\"key\": \"2019-03-11\", \"count\": 194}, {\"key\": \"2019-03-18\", \"count\": 170}, "
  "{\"key\": \"2019-03-25\", \"count\": 162}, {\"key\": \"2019-04-01\", \"count\": 179}, "
  "{\"key\": \"2019-04-08\", \"count\": 171}, {\"key\": \"2019-04-15\", \"count\": 184}, "
  "{\"key\": \"2019-04-22\", \"count\": 186}, {\"key\": \"2019-04-29\", \"count\": 197}, "
  "{\"key\": \"2019-05-06\", \"count\": 178}, {\"key\": \"2019-05-13\", \"count\": 110}"
  "]}",
  "{\"level\": ["
  "{\"key\": \"2018-12\", \"count\": 811}, {\"key\": \"2019-01\", \"count\": 805}, "
  "{\"key\": \"2019-02\", \"count\": 763}, {\"key\": \"2019-03\", \"count\": 793}, "
  "{\"key\": \"2019-04\", \"count\": 773}, {\"key\": \"2019-05\", \"count\": 432}"
  "]}",
  "{\"level\": ["
  "{"
  "\"key\": \"polyline_example\", "
  "\"count\": 4779, "
  "\"level\": ["
  "{\"key\": \"polyline_example\", "
  "\"count\": 4779, "
  "\"level\": []}"
  "]"
  "}, "
  "{"
  "\"key\": \"points_example\", "
  "\"count\": 4755, "
  "\"level\": ["
  "{\"key\": \"points_example\", "
  "\"count\": 4755, "
  "\"level\": []}"
  "]"
  "}, "
  "{"
  "\"key\": \"polygon_example\", "
  "\"count\": 4728, "
  "\"level\": ["
  "{\"key\": \"polygon_example\", "
  "\"count\": 4728, "
  "\"level\": []}"
  "]"
  "}, "
  "{"
  "\"key\": \"human_body\","
  "\"count\": 1617,"
  "\"level\": [{\"key\": \"人脸框\","
  "\"count\": 1617,"
  "\"level\": []}"
  "]"
  "},"
  "{"
  "\"key\": \"animal_body\","
  "\"count\": 1611, "
  "\"level\":"
  " ["
  "{\"key\": \"动物框\","
  "\"count\": 1611, "
  "\"level\": []}"
  "]"
  "}, "
  "{"
  "\"key\": \"plant_body\","
  "\"count\": 1539,"
  "\"level\": ["
  "{\"key\": \"植物框\","
  "\"count\": 1539, "
  "\"level\": []}"
  "]"
  "},"
  "{"
  "\"key\": \"106点人脸\","
  "\"count\": 1227,"
  "\"level\": ["
  "{\"key\": \"特征点\", "
  "\"count\": 1227,"
  "\"level\": []},"
  "{\"key\": \"脸部评分\", "
  "\"count\": 1227,"
  "\"level\": ["
  "{\"key\": \"大小\", "
  "\"count\": 325},"
  "{\"key\": \"层次\", "
  "\"count\": 325},"
  "{\"key\": \"细节\", "
  "\"count\": 309},"
  "{\"key\": \"色彩\", "
  "\"count\": 268}"
  "]}"
  "]},"
  " {\"key\": \"5点人脸\", \"count\": 1207,"
  " \"level\": ["
  "{\"key\": \"特征点\", \"count\": 1207,"
  " \"level\": []},"
  " {\"key\": \"脸部评分\", \"count\": 1207,"
  " \"level\": ["
  "{\"key\": \"大小\", \"count\": 320},"
  " {\"key\": \"色彩\", \"count\": 298},"
  " {\"key\": \"层次\", \"count\": 297},"
  " {\"key\": \"细节\", \"count\": 292}]}]},"
  " {\"key\": \"68点人脸\", \"count\": 1184,"
  " \"level\": ["
  "{\"key\": \"特征点\", \"count\": 1184,"
  " \"level\": []}, "
  "{\"key\": \"脸部评分\", \"count\": 1184,"
  " \"level\": ["
  "{\"key\": \"大小\", \"count\": 304},"
  " {\"key\": \"色彩\", \"count\": 303},"
  " {\"key\": \"层次\", \"count\": 290},"
  " {\"key\": \"细节\", \"count\": 287}]}]},"
  " {\"key\": \"276点人脸\", \"count\": 1163,"
  " \"level\": ["
  "{\"key\": \"特征点\", \"count\": 1163,"
  " \"level\": []},"
  " {\"key\": \"脸部评分\", \"count\": 1163,"
  " \"level\": [{\"key\": \"细节\", \"count\": 310},"
  " {\"key\": \"色彩\", \"count\": 298},"
  " {\"key\": \"层次\", \"count\": 279},"
  " {\"key\": \"大小\", \"count\": 276}]}]}]}"};
#endif  // TESTS_MINDRECORD_CONFIGURATION_H_
