# Copyright 2019-2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

import numpy as np
import pytest

import mindspore.context as context
import mindspore.nn as nn
from mindspore import Tensor
from mindspore.ops import operations as P
from mindspore.ops.operations import _inner_ops as inner

class SparseGatherNet(nn.Cell):
    def __init__(self):
        super(SparseGatherNet, self).__init__()
        self.gather = P.SparseGatherV2()

    def construct(self, x, indices):
        return self.gather(x, indices, 1)


@pytest.mark.level0
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather0():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.float32).reshape(2, 3, 4, 5))
    indices = Tensor(np.ones((2, 2, 4, 5), dtype=np.int32))
    expect = np.array([[[[[[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]]],
                         [[[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]]]],
                        [[[[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]]],
                         [[[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]],
                          [[[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]],
                           [[20., 21., 22., 23., 24.],
                            [25., 26., 27., 28., 29.],
                            [30., 31., 32., 33., 34.],
                            [35., 36., 37., 38., 39.]]]]]],
                       [[[[[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]]],
                         [[[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]]]],
                        [[[[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]]],
                         [[[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]],
                          [[[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]],
                           [[80., 81., 82., 83., 84.],
                            [85., 86., 87., 88., 89.],
                            [90., 91., 92., 93., 94.],
                            [95., 96., 97., 98., 99.]]]]]]])

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = SparseGatherNet()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


class SparseGatherNet1(nn.Cell):
    def __init__(self):
        super(SparseGatherNet1, self).__init__()
        self.gather = P.SparseGatherV2()

    def construct(self, x, indices):
        return self.gather(x, indices, -1)


@pytest.mark.level0
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather1():
    x = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.float32).reshape(2, 3, 4, 5))
    indices = Tensor(np.array([1, 3, 4], dtype=np.int32))
    expect = np.array([[[[1., 3., 4.],
                         [6., 8., 9.],
                         [11., 13., 14.],
                         [16., 18., 19.]],
                        [[21., 23., 24.],
                         [26., 28., 29.],
                         [31., 33., 34.],
                         [36., 38., 39.]],
                        [[41., 43., 44.],
                         [46., 48., 49.],
                         [51., 53., 54.],
                         [56., 58., 59.]]],
                       [[[61., 63., 64.],
                         [66., 68., 69.],
                         [71., 73., 74.],
                         [76., 78., 79.]],
                        [[81., 83., 84.],
                         [86., 88., 89.],
                         [91., 93., 94.],
                         [96., 98., 99.]],
                        [[101., 103., 104.],
                         [106., 108., 109.],
                         [111., 113., 114.],
                         [116., 118., 119.]]]])

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = SparseGatherNet1()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


class SparseGatherNet2(nn.Cell):
    def __init__(self):
        super(SparseGatherNet2, self).__init__()
        self.gather = P.SparseGatherV2()

    def construct(self, x, indices):
        return self.gather(x, indices, 0)


@pytest.mark.level0
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather2():
    x = Tensor(np.array([[4., 5., 4., 1., 5.,],
                         [4., 9., 5., 6., 4.,],
                         [9., 8., 4., 3., 6.,],
                         [0., 4., 2., 2., 8.,],
                         [1., 8., 6., 2., 8.,],
                         [8., 1., 9., 7., 3.,],
                         [7., 9., 2., 5., 7.,],
                         [9., 8., 6., 8., 5.,],
                         [3., 7., 2., 7., 4.,],
                         [4., 2., 8., 2., 9.,]]
                        ).astype(np.float32))
    indices = Tensor(np.array([[4000, 1, 300000]]).astype(np.int32))
    expect = np.array([[[0., 0., 0., 0., 0.],
                        [4., 9., 5., 6., 4.],
                        [0., 0., 0., 0., 0.]]])

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = SparseGatherNet2()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


class SparseGatherDynamicNet(nn.Cell):
    def __init__(self):
        super(SparseGatherDynamicNet, self).__init__()
        self.gather = P.SparseGatherV2()
        self.test_dynamic = inner.GpuConvertToDynamicShape()

    def construct(self, x, indices):
        out = self.test_dynamic(x)
        return self.gather(out, indices, 0)


@pytest.mark.level0
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather_d():
    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    x = Tensor(np.array([[4., 5., 4., 1., 5.,],
                         [4., 9., 5., 6., 4.,],
                         [9., 8., 4., 3., 6.,],
                         [0., 4., 2., 2., 8.,],
                         [1., 8., 6., 2., 8.,],
                         [8., 1., 9., 7., 3.,],
                         [7., 9., 2., 5., 7.,],
                         [9., 8., 6., 8., 5.,],
                         [3., 7., 2., 7., 4.,],
                         [4., 2., 8., 2., 9.,]]
                        ).astype(np.float32))
    indices = Tensor(np.array([[4000, 1, 300000]]).astype(np.int32))
    expect = np.array([[[0., 0., 0., 0., 0.],
                        [4., 9., 5., 6., 4.],
                        [0., 0., 0., 0., 0.]]])

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = SparseGatherDynamicNet()
    output = gather(x, indices)
    error = np.ones(shape=output.asnumpy().shape) * 1.0e-6
    diff = output.asnumpy() - expect
    assert np.all(diff < error)
    assert np.all(-diff < error)


class SparseGatherDynamicNet2(nn.Cell):
    def __init__(self):
        super(SparseGatherDynamicNet2, self).__init__()
        self.gather = P.SparseGatherV2()
        self.test_dynamic = inner.GpuConvertToDynamicShape()

    def construct(self, x_1, x_2, indices_1, indices_2):
        out_1 = self.test_dynamic(x_1)
        out_1 = self.gather(out_1, indices_1, 0)
        out_2 = self.test_dynamic(x_2)
        out_2 = self.gather(out_2, indices_2, -1)
        return (out_1, out_2)


@pytest.mark.level0
@pytest.mark.platform_x86_gpu_training
@pytest.mark.env_onecard
def test_gather_d_two_inputs():
    x_1 = Tensor(np.array([[4., 5., 4., 1., 5.,],
                           [4., 9., 5., 6., 4.,],
                           [9., 8., 4., 3., 6.,],
                           [0., 4., 2., 2., 8.,],
                           [1., 8., 6., 2., 8.,],
                           [8., 1., 9., 7., 3.,],
                           [7., 9., 2., 5., 7.,],
                           [9., 8., 6., 8., 5.,],
                           [3., 7., 2., 7., 4.,],
                           [4., 2., 8., 2., 9.,]]
                         ).astype(np.float32))
    indices_1 = Tensor(np.array([[4000, 1, 300000]]).astype(np.int32))
    expect_1 = np.array([[[0., 0., 0., 0., 0.],
                          [4., 9., 5., 6., 4.],
                          [0., 0., 0., 0., 0.]]])
    x_2 = Tensor(np.arange(2 * 3 * 4 * 5, dtype=np.float32).reshape(2, 3, 4, 5))
    indices_2 = Tensor(np.array([1, 3, 4], dtype=np.int32))
    expect_2 = np.array([[[[1., 3., 4.],
                           [6., 8., 9.],
                           [11., 13., 14.],
                           [16., 18., 19.]],
                          [[21., 23., 24.],
                           [26., 28., 29.],
                           [31., 33., 34.],
                           [36., 38., 39.]],
                          [[41., 43., 44.],
                           [46., 48., 49.],
                           [51., 53., 54.],
                           [56., 58., 59.]]],
                         [[[61., 63., 64.],
                           [66., 68., 69.],
                           [71., 73., 74.],
                           [76., 78., 79.]],
                          [[81., 83., 84.],
                           [86., 88., 89.],
                           [91., 93., 94.],
                           [96., 98., 99.]],
                          [[101., 103., 104.],
                           [106., 108., 109.],
                           [111., 113., 114.],
                           [116., 118., 119.]]]])

    context.set_context(mode=context.GRAPH_MODE, device_target="GPU")
    gather = SparseGatherDynamicNet2()
    output_1, output_2 = gather(x_1, x_2, indices_1, indices_2)
    error_1 = np.ones(shape=output_1.asnumpy().shape) * 1.0e-6
    error_2 = np.ones(shape=output_2.asnumpy().shape) * 1.0e-6
    diff_1 = output_1.asnumpy() - expect_1
    diff_2 = output_2.asnumpy() - expect_2
    assert np.all(diff_1 < error_1)
    assert np.all(-diff_1 < error_1)
    assert np.all(diff_2 < error_2)
    assert np.all(-diff_2 < error_2)
