# Contents

- [Description](#description)
- [Model Architecture](#model-architecture)
- [Dataset](#dataset)
- [Environment Requirements](#environment-requirements)
- [Script Description](#script-description)
    - [Script and Sample Code](#script-and-sample-code)
    - [Training Process](#training-process)
    - [Evaluation Process](#evaluation-process)
    - [Result](#result)
- [ModelZoo Homepage](#modelzoo-homepage)

## Description

Molecular Dynamics (MD) is playing an increasingly important role in the research of biology, pharmacy, chemistry, and materials science.  The architecture is based on DeePMD, which using an NN scheme for MD simulations, which overcomes the limitations associated to auxiliary quantities like the symmetry functions or the Coulomb matrix. Each environment contains a number of atoms, whose local coordinates are arranged in a symmetry preserving way following the prescription of the Deep Potential method. According to the atomic position, atomic types and box tensor to construct energy, force and virial.

Thanks a lot for DeePMD team's help.

[1] Paper: L Zhang, J Han, H Wang, R Car, W E. Deep potential molecular dynamics: a scalable model with the accuracy of quantum mechanics. Physical review letters 120 (14), 143001 (2018).

[2] Paper: H Wang, L Zhang, J Han, W E. DeePMD-kit: A deep learning package for many-body potential energy representation and molecular dynamics. Computer Physics Communications 228, 178-184 (2018).

## Model Architecture

The overall network architecture of MD simulation is show below.

[Link](https://arxiv.org/abs/1707.09571)

## Dataset

Dataset used:  deepmodeling/deepmd-kit/examples/water/data

The data is generated by Quantum Espresso and the input of Quantum Espresso is set manually.

The directory structure of the dataset is as follows:

```text
└─data
    ├─type.raw
    ├─set.000
    │   ├──box.npy
    │   ├──coord.npy
    │   ├──energy.npy
    │   └──force.npy
    ├─set.001
    ├─set.002
    └─set.003
```

In `deepmodeling/deepmd-kit/source`:

- Use `train/DataSystem.py` to get d_coord and atype.
- Use function compute_input_stats in `train/DataSystem.py` to get avg and std.
- Use `op/descrpt_se_a.cc` to get d_nlist and nlist.
- Save d_coord, d_nlist, atype, avg, std and nlist as `Npz` file for inference.

## Environment Requirements

- Hardware (Ascend)
- Framework
    - [MindSpore](https://www.mindspore.cn/install/en)
- For more information, please check the resources below:
    - [MindSpore Tutorials](https://www.mindspore.cn/tutorial/training/en/master/index.html)
    - [MindSpore Python API](https://www.mindspore.cn/doc/api_python/en/master/index.html)

## Script Description

### Script and Sample Code

```shell
├── md
    ├── README.md               # descriptions about MD
    ├── script
    │   ├── eval.sh             # evaluation script
    ├── src
    │   ├── descriptor.py       # descriptor function
    │   ├── virial.py           # calculating virial function
    │   └── network.py          # MD simulation architecture
    └── eval.py                 # evaluation interface
```

### Training Process

To Be Done

### Evaluation Process

After installing MindSpore via the official website, you can start evaluation as follows:

```shell
python eval.py --dataset_path [DATASET_PATH] --checkpoint_path [CHECKPOINT_PATH]
```

> checkpoint can be trained by using DeePMD-kit, and convert into the ckpt of MindSpore.

### Result

The infer result：

```text
energy: -29944.03
atom_energy: -94.38766   -94.294426  -94.39194   -94.70758   -94.51311   -94.457954 ...
force: 1.649112 -1.0982257  0.46055675 -1.3491507 -0.3382736 -0.97184074 ...
virial: -11.736662   -4.2862144    2.8852935  -4.286209  -10.408775   -5.6738224 ...
```

## ModelZoo Homepage

Please check the official [homepage](https://gitee.com/mindspore/mindspore/tree/master/model_zoo).

