#!/bin/bash
# Copyright 2020 Huawei Technologies Co., Ltd
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

if [ $# != 4 ] && [ $# != 3 ]; then
  echo "Usage: sh run_eval.sh [DATASET_NAME] [DATASET_PATH] [CHECKPOINT_PATH] [PLATFORM](optional) "
  exit 1
fi

get_real_path() {
  if [ "${1:0:1}" == "/" ]; then
    echo "$1"
  else
    echo "$(realpath -m $PWD/$1)"
  fi
}

DATASET_NAME=$1
PATH1=$(get_real_path $2)
PATH2=$(get_real_path $3)

if [ $# == 4 ]; then
  PLATFORM=$4
else
  PLATFORM="Ascend"
fi

if [ ! -d $PATH1 ]; then
  echo "error: DATASET_PATH=$PATH1 is not a directory"
  exit 1
fi

if [ ! -f $PATH2 ]; then
  echo "error: CHECKPOINT_PATH=$PATH2 is not a file"
  exit 1
fi

run_ascend() {
  ulimit -u unlimited
  export DEVICE_NUM=1
  export DEVICE_ID=0
  export RANK_SIZE=$DEVICE_NUM
  export RANK_ID=0

  if [ -d "eval" ]; then
    rm -rf ./eval
  fi
  mkdir ./eval
  cp ../*.py ./eval
  cp -r ../src ./eval
  cd ./eval || exit
  env >env.log
  echo "start evaluation for device $DEVICE_ID"
  python eval.py --dataset=$DATASET_NAME --dataset_path=$1 --checkpoint_path=$2 --platform=Ascend > log.txt 2>&1 &
  cd ..
}

run_gpu() {
  if [ -d "eval" ]; then
    rm -rf ./eval
  fi
  mkdir ./eval
  cp ../*.py ./eval
  cp -r ../src ./eval
  cd ./eval || exit
  env >env.log
  python eval.py --dataset=$DATASET_NAME \
                 --dataset_path=$1 \
                 --checkpoint_path=$2 \
                 --platform=GPU \
                 --dataset=$DATASET_NAME > log.txt 2>&1 &
  cd ..
}

if [ "Ascend" == $PLATFORM ]; then
  run_ascend $PATH1 $PATH2
elif [ "GPU" == $PLATFORM ]; then
  run_gpu $PATH1 $PATH2
else
  echo "error: PLATFORM=$PLATFORM is not support, only support Ascend and GPU."
fi

