/**
 * Copyright 2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "nnacl/squeeze.h"
#include <string.h>
#include "nnacl/errorcode.h"

int DoSqueeze(const float *in_data, float *out_data, size_t data_size) {
  if (in_data == NULL || out_data == NULL) {
    return NNACL_ERR;
  }
  (void)memcpy(out_data, in_data, data_size);
  return NNACL_OK;
}

int DoSqueezeInt32(int32_t *in_data, int32_t *out_data, size_t data_size) {
  if (in_data == NULL || out_data == NULL) {
    return NNACL_ERR;
  }
  (void)memcpy(out_data, in_data, data_size);
  return NNACL_OK;
}
