/**
 * Copyright 2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_LITE_NNACL_INT8_TRANSPOSE_INT8_H_
#define MINDSPORE_LITE_NNACL_INT8_TRANSPOSE_INT8_H_

#include <string.h>
#include "nnacl/transpose.h"
#include "nnacl/errorcode.h"

#ifdef __cplusplus
extern "C" {
#endif

int DoTransposeInt8(const int8_t *in_data, int8_t *out_data, const int *output_shape,
                    TransposeParameter *transpose_param, int h_start, int h_end, int *dim_size, int *position);

#ifdef __cplusplus
}
#endif

#endif  // MINDSPORE_LITE_NNACL_INT8_TRANSPOSE_INT8_H_
