/**
 * Copyright 2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_CORE_C_OPS_DEPEND_H_
#define MINDSPORE_CORE_C_OPS_DEPEND_H_
#include <vector>
#include <memory>

#include "c_ops/primitive_c.h"
#include "c_ops/op_utils.h"
#include "abstract/abstract_value.h"

namespace mindspore {
constexpr auto kNameDepend = "Depend";
class Depend : public PrimitiveC {
 public:
  Depend() : PrimitiveC(kNameDepend) {}
  ~Depend() = default;
  MS_DECLARE_PARENT(Depend, PrimitiveC);
  void Init();
};
AbstractBasePtr DependInfer(const abstract::AnalysisEnginePtr &, const PrimitivePtr &primitive,
                            const std::vector<AbstractBasePtr> &input_args);
using PrimDepend = std::shared_ptr<Depend>;
}  // namespace mindspore
#endif  // MINDSPORE_CORE_C_OPS_DEPEND_H_
