/**
 * Copyright 2019 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MINDSPORE_GET_NEXT_KERNEL_H
#define MINDSPORE_GET_NEXT_KERNEL_H

#include <memory>
#include <string>
#include <vector>
#include "backend/kernel_compiler/gpu/data/dataset_profiling.h"
#include "backend/kernel_compiler/gpu/gpu_kernel.h"
#include "backend/kernel_compiler/gpu/gpu_kernel_factory.h"

namespace mindspore {
namespace kernel {
class DatasetIteratorKernel : public GpuKernel {
 public:
  DatasetIteratorKernel();
  ~DatasetIteratorKernel();

  const std::vector<size_t> &GetInputSizeList() const override;
  const std::vector<size_t> &GetOutputSizeList() const override;
  const std::vector<size_t> &GetWorkspaceSizeList() const override;
  bool Launch(const std::vector<AddressPtr> &inputs, const std::vector<AddressPtr> &workspace,
              const std::vector<AddressPtr> &outputs, void *stream_ptr) override;
  bool Init(const CNodePtr &kernel_node) override;
  void ReleaseResource() override;

 protected:
  void InitSizeLists() override;

 private:
  bool ReadDevice(void **addr, size_t *len);
  std::string queue_name_;
  unsigned int handle_;
  size_t total_bytes_;
  bool profiling_enable_;
  std::shared_ptr<GetNextProfiling> profiling_op_;

  std::vector<size_t> input_size_list_;
  std::vector<size_t> output_size_list_;
  std::vector<size_t> workspace_size_list_;
};

MS_REG_GPU_KERNEL(GetNext, DatasetIteratorKernel)
}  // namespace kernel
}  // namespace mindspore

#endif  // MINDSPORE_QUEUE_CPU_KERNEL_H
