/**
 * Copyright 2020 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "backend/kernel_compiler/akg/akg_kernel_metadata.h"
#include <memory>
#include "backend/session/anf_runtime_algorithm.h"
#include "backend/kernel_compiler/oplib/oplib.h"
#include "backend/kernel_compiler/common_utils.h"

namespace mindspore {
namespace kernel {
void AkgMetadataInfo(const CNodePtr &kernel_node,
                     std::vector<std::shared_ptr<KernelBuildInfo>> *const kernel_info_list) {
  MS_EXCEPTION_IF_NULL(kernel_node);
  MS_EXCEPTION_IF_NULL(kernel_info_list);

  std::string op_name = AnfAlgo::GetCNodeName(kernel_node);
  for (size_t i = 0; i < support_devices.size(); i++) {
    auto op_info_ptr = mindspore::kernel::OpLib::FindOp(op_name, OpImplyType::kAKG);
    if (op_info_ptr == nullptr) {
      continue;
    }

    if (!ParseMetadata(kernel_node, op_info_ptr, Processor(i), kernel_info_list)) {
      MS_LOG(WARNING) << "Akg parsed metadata of op[" << op_name << "], device[" << support_devices[i] << "] failed.";
    } else {
      MS_LOG(DEBUG) << "Akg parsed metadata of op[" << op_name << "], device[" << support_devices[i] << "].";
      break;
    }
  }

  if (kernel_info_list->empty()) {
    MS_LOG(WARNING) << "Akg dose not has metadata of op[" << op_name << "].";
  }
}
}  // namespace kernel
}  // namespace mindspore
