message(STATUS "compiling GraphEngine")
set(GE_SOURCE_DIR ${CMAKE_SOURCE_DIR}/graphengine)

message(STATUS "ge dir: ${GE_SOURCE_DIR}")
include(${GE_SOURCE_DIR}/cmake/ge_utils.cmake)
include(${GE_SOURCE_DIR}/cmake/external_libs/json.cmake)
include(${GE_SOURCE_DIR}/cmake/external_libs/eigen.cmake)
include(${GE_SOURCE_DIR}/cmake/external_libs/gtest.cmake)
include(${GE_SOURCE_DIR}/cmake/external_libs/onnx.cmake)
include(${GE_SOURCE_DIR}/cmake/external_libs/securec.cmake)
if (ENABLE_D)
    set(AS_MS_COMP TRUE)
    include(${GE_SOURCE_DIR}/cmake/external_libs/protobuf.cmake)
    unset(AS_MS_COMP)
else ()
    include(${GE_SOURCE_DIR}/cmake/external_libs/protobuf.cmake)
endif ()
# for UT, find slog and error_manager from local prebuild
if (NOT ENABLE_D AND NOT ENABLE_ACL)
    set(GE_PREBUILD_PATH ${GE_SOURCE_DIR}/third_party/prebuild/${CMAKE_HOST_SYSTEM_PROCESSOR})
    find_library(slog libslog.so ${GE_PREBUILD_PATH})
    find_library(error_manager liberror_manager.so ${GE_PREBUILD_PATH})
    find_library(mmpa libmmpa.a ${GE_PREBUILD_PATH})
elseif (DEFINED ENV{D_LINK_PATH})
    set(GE_LIB_PATH $ENV{D_LINK_PATH})
    set(GE_SYS_ARCH "")
    if(CMAKE_HOST_SYSTEM_PROCESSOR MATCHES "x86_64")
        # x86 ubuntu
        set(GE_SYS_ARCH "x86_64")
    elseif(CMAKE_HOST_SYSTEM_PROCESSOR MATCHES "aarch64")
        # arm euleros
        set(GE_SYS_ARCH "aarch64")
    else()
        message(FATAL_ERROR "Running on a unsupported architecture: ${SYSTEM_TYPE}, build terminated")
    endif()
    set(GE_LIB_PATH ${GE_LIB_PATH}/${GE_SYS_ARCH})
    find_library(c_sec libc_sec.so ${GE_LIB_PATH})
    find_library(slog libslog.so ${GE_LIB_PATH})
    find_library(mmpa libmmpa.a ${GE_LIB_PATH})
    find_library(runtime libruntime.so ${GE_LIB_PATH})
    find_library(register libregister.so ${GE_LIB_PATH})
    find_library(hccl libhccl.so ${GE_LIB_PATH})
    find_library(cce libcce.so ${GE_LIB_PATH})
    find_library(resource libresource.so ${GE_LIB_PATH})
    find_library(error_manager liberror_manager.so ${GE_LIB_PATH})
else()
    # Ascend mode
    if(DEFINED ENV{ASCEND_CUSTOM_PATH})
        set(ASCEND_PATH $ENV{ASCEND_CUSTOM_PATH})
    else()
        set(ASCEND_PATH /usr/local/Ascend)
    endif()
    set(ASCEND_DRIVER_PATH ${ASCEND_PATH}/driver/lib64/common ${ASCEND_PATH}/driver/lib64)
    set(ASCEND_RUNTIME_PATH ${ASCEND_PATH}/fwkacllib/lib64 ${ASCEND_PATH}/acllib/lib64 ${ASCEND_PATH}/atc/lib64)
    find_library(c_sec libc_sec.so ${ASCEND_DRIVER_PATH})
    find_library(slog libslog.so ${ASCEND_DRIVER_PATH})
    find_library(mmpa libmmpa.a ${ASCEND_RUNTIME_PATH})
    find_library(cce libcce.so ${ASCEND_RUNTIME_PATH})
    find_library(hccl libhccl.so ${ASCEND_RUNTIME_PATH})
    find_library(runtime libruntime.so ${ASCEND_RUNTIME_PATH})
    find_library(register libregister.so ${ASCEND_RUNTIME_PATH})
    find_library(resource libresource.so ${ASCEND_RUNTIME_PATH})
    find_library(error_manager liberror_manager.so ${ASCEND_RUNTIME_PATH})
    # for Atlas env
    set(ASCEND_TOOLKIT_RUNTIME_PATH ${ASCEND_PATH}/ascend-toolkit/latest/fwkacllib/lib64)
    find_library(cce libcce.so ${ASCEND_TOOLKIT_RUNTIME_PATH})
    find_library(hccl libhccl.so ${ASCEND_TOOLKIT_RUNTIME_PATH})
    find_library(runtime libruntime.so ${ASCEND_TOOLKIT_RUNTIME_PATH})
    find_library(register libregister.so ${ASCEND_TOOLKIT_RUNTIME_PATH})
    find_library(resource libresource.so ${ASCEND_TOOLKIT_RUNTIME_PATH})
    find_library(error_manager liberror_manager.so ${ASCEND_TOOLKIT_RUNTIME_PATH})
endif()

# compile libraries from following directories
# this cmake file is called only when NOT ENABLE_GE is set
set(_ge_tmp_CMAKE_CXX_FLAGS ${CMAKE_CXX_FLAGS})

string(REPLACE " -Wall" "" CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}")
string(REPLACE " -Werror" "" CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}")
# force __FILE__ to show relative path of file, from source directory
set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -D__FILE__='\"$(subst $(realpath ${CMAKE_SOURCE_DIR})/,,$(abspath $<))\"' -Wno-builtin-macro-redefined")
add_subdirectory(${GE_SOURCE_DIR}/src/common/graph)
if (ENABLE_ACL OR ENABLE_D)
    add_subdirectory(${GE_SOURCE_DIR}/src/ge/common)
    target_compile_definitions(graph PRIVATE google=ascend_private)
    set_target_properties(graph PROPERTIES SKIP_BUILD_RPATH TRUE)
    if (ENABLE_D)
        add_subdirectory(${GE_SOURCE_DIR}/src/ge/ge_runtime)
        target_compile_definitions(ge_runtime PRIVATE google=ascend_private)
        set_target_properties(ge_runtime PROPERTIES SKIP_BUILD_RPATH TRUE)
    endif ()
endif ()

set(CMAKE_CXX_FLAGS ${_ge_tmp_CMAKE_CXX_FLAGS})
