# Community Roles

<!-- TOC -->

-   [TSC Members](#tsc-members)
-   [Committers](#committers)
-   [Reviewers](#reviewers)
-   [Contributors](#contributors)

<!-- /TOC -->

## TSC Members

The Technical Steering Committee (TSC) functions as the core management team that oversees the Milvus community. The TSC decides the roadmap of the project and makes major decisions related to the community.

TSC members have the following responsibilities:

-   Coordinate the technical direction of the project.
-   Approve project or system proposals.
-   Decide on formal releases of the project's software.
-   Organize and remove sub-projects.
-   Coordinate any marketing, events, or communications regarding the project.

To become a TSC member, a committer must be sponsored by a TSC member and the sponsorship must be approved by 2/3 of all TSC members.

The TSC members are listed below:

-   [cxie](https://github.com/cxie)
-   [JinHai-CN](https://github.com/JinHai-CN)

## Committers

Committers lead project feature discussions and oversee the overall project quality.

Committers have the following responsibilities:

-   Lead feature design discussions and implementation.
-   Ensure the overall project quality and approve PRs.
-   Participate in product release, feature planning, and roadmap design.
-   Have a constructive and friendly attitude in all community interactions.
-   Mentor reviewers and contributors.

To become a committer, a reviewer must have contributed broadly throughout the Milvus project. A reviewer must also be sponsored by a committer and the sponsorship must be approved by the TSC.

The committers are listed below:

-   [JinHai-CN](https://github.com/JinHai-CN)

## Reviewers

Reviewers review new code contributions and ensure the quality of existing code.

Reviewers have the following responsibilities:

-   Participate in feature design discussion and implementation.
-   Ensure the quality of owned code modules.
-   Ensure the technical accuracy of documentation.
-   Quickly respond to issues and PRs and conduct code reviews.

To become a reviewer, a contributor must have provided continued and quality contribution to the Milvus project for at least 6 months and have contributed at least one major component where the contributor has taken an ownership role.

The reviewers are listed below:

-   [XuPeng-SH](https://github.com/XuPeng-SH)
-   [yhmo](https://github.com/yhmo)
-   [scsven](https://github.com/scsven)
-   [cydrain](https://github.com/cydrain)
-   [shengjun1985](https://github.com/shengjun1985)

## Contributors

Contributors can be anyone who has successfully submitted at least one PR to the Milvus project.

The contributors are listed below:

-   [ZhifengZhang-CN](https://github.com/ZhifengZhang-CN)
-   [tinkerlin](https://github.com/tinkerlin)
-   [youny626](https://github.com/youny626)
-   [fishpenguin](https://github.com/fishpenguin)
-   [BossZou](https://github.com/BossZou)
-   [del-zhenwu](https://github.com/del-zhenwu)
-   [jielinxu](https://github.com/jielinxu)
-   [yamasite](https://github.com/yamasite)
-   [Yukikaze-CZR](https://github.com/Yukikaze-CZR)
-   [Heisenberg-Y](https://github.com/Heisenberg-Y)
-   [sahuang](https://github.com/sahuang)
-   [op-hunter](https://github.com/op-hunter)
-   [GuanyunFeng](https://github.com/GuanyunFeng)
-   [thywdy](https://github.com/thywdy)
-   [erdustiggen](https://github.com/erdustiggen)
-   [akihoni](https://github.com/akihoni)
-   [shiyu22](https://github.com/shiyu22)
-   [shengjh](https://github.com/shengjh)
-   [dvzubarev](https://github.com/dvzubarev)
-   [aaronjin2010](https://github.com/aaronjin2010)
-   [ReigenAraka](https://github.com/ReigenAraka)
-   [JackLCL](https://github.com/JackLCL)
-   [Bennu-Li](https://github.com/Bennu-Li)
-   [ABNER-1](https://github.com/ABNER-1)
