"""
Copyright (c) Facebook, Inc. and its affiliates.
"""

# fmt: off
'''
Every template contains an ordered list of TemplateObjects.
TemplateObject is defined in template_objects.py

Copy templates are written for a BlockObject and may have a Location,
and represent the intent for the action: Copy.
This action builds a copy of a physical block object that already exists in the
environment.

Examples:

[Human, Copy, The, Colour, AbstractDescription, NTimes]
- make a copy of the red thing 4 times
- copy the blue structure 2 times

[Human, Copy, RepeatCount, AbstractDescription]
- copy 4 shapes
- make a copy of 4 structures
'''


from template_objects import *

COPY_WITH_CORRECTION = [
    ## Single word Copy command ##
    [[Human, CopySingle],
     [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     ## Copy X n times ##
     # Abstract #
     [[Human, Copy, The, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, The, Size, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, The, Size, Colour, AbstractDescription, NTimes],
     [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     [[Human, Copy, BlockObjectThat, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, Size, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

      [[Human, Copy, BlockObjectThat, AbstractDescription, NTimes],
       [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
      [[Human, Copy, BlockObjectThat, Colour, AbstractDescription, NTimes],
       [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
      [[Human, Copy, BlockObjectThat, Size, AbstractDescription, NTimes],
       [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
      [[Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, NTimes],
       [HumanReplace, The, AbstractDescription, BlockObjectLocation]],

     [[Human, Copy, BlockObjectThis, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThis, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThis, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThis, Size, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     [[Human, Copy, BlockObjectThis, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThis, AbstractDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThis, Colour, AbstractDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThis, Size, AbstractDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],

     [[Human, Copy, BlockObjectIt, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectIt, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     ## Concrete ##
     [[Human, Copy, The, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, The, Colour, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, The, Size, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, The, Size, Colour, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     [[Human, Copy, BlockObjectThat, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThose, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThese, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],

      [[Human, Copy, BlockObjectThat, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
      [[Human, Copy, BlockObjectThose, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
      [[Human, Copy, BlockObjectThese, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     [[Human, Copy, BlockObjectThat, ConcreteDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, Colour, ConcreteDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, Size, ConcreteDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],

      [[Human, Copy, BlockObjectThat, ConcreteDescription, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
      [[Human, Copy, BlockObjectThat, Colour, ConcreteDescription, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
      [[Human, Copy, BlockObjectThat, Size, ConcreteDescription, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
      [[Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     [[Human, Copy, BlockObjectThis, ConcreteDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThis, Colour, ConcreteDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThis, Size, ConcreteDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, NTimes],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],

     [[Human, Copy, BlockObjectThis, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThis, Colour, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThis, Size, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     ## Copy n of X ##
     # Abstract #
     [[Human, Copy, RepeatCount, AbstractDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, RepeatCount, Colour, AbstractDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, RepeatCount, Size, AbstractDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, RepeatCount, Size, Colour, AbstractDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],

     [[Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],

     [[Human, Copy, RepeatCount, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, RepeatCount, Colour, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, RepeatCount, Size, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, RepeatCount, Size, Colour, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     [[Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     # Concrete #
     [[Human, Copy, RepeatCount, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, RepeatCount, Colour, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, RepeatCount, Size, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, RepeatCount, Size, Colour, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

     [[Human, Copy, BlockObjectThose, RepeatCount],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThese, RepeatCount],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription],
      [HumanReplace, The, AbstractDescription, BlockObjectLocation]],

     [[Human, Copy, BlockObjectThose, RepeatCount],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThese, RepeatCount],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, LocationMobTemplate]],

    ## Adding rel_dir of BlockObjectThat templates ##
    ## Single word Copy command ##
    [[Human, CopySingle],
     [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     ## Copy X n times ##
     ## Abstract #
     [[Human, Copy, The, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, The, Size, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, The, Size, Colour, AbstractDescription, NTimes],
     [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     [[Human, Copy, BlockObjectThat, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, Size, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     [[Human, Copy, BlockObjectThis, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThis, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThis, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThis, Size, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

    [[Human, Copy, BlockObjectIt, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     ## Concrete ##
     [[Human, Copy, The, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, The, Colour, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, The, Size, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, The, Size, Colour, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

      [[Human, Copy, BlockObjectThat, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
      [[Human, Copy, BlockObjectThose, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
      [[Human, Copy, BlockObjectThese, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

      [[Human, Copy, BlockObjectThat, ConcreteDescription, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
      [[Human, Copy, BlockObjectThat, Colour, ConcreteDescription, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
      [[Human, Copy, BlockObjectThat, Size, ConcreteDescription, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
      [[Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, NTimes],
       [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     [[Human, Copy, BlockObjectThis, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThis, Colour, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThis, Size, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, NTimes],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     [[Human, Copy, RepeatCount, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, RepeatCount, Colour, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, RepeatCount, Size, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, RepeatCount, Size, Colour, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     [[Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     ## Concrete #
     [[Human, Copy, RepeatCount, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, RepeatCount, Colour, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, RepeatCount, Size, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, RepeatCount, Size, Colour, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],

     [[Human, Copy, BlockObjectThose, RepeatCount],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThese, RepeatCount],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
     [[Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription],
      [HumanReplace, Copy, RelativeDirectionTemplate, BlockObjectThat]],
    ]
COPY_TEMPLATES = [
    ## Copy X n times ##
    # Abstract #
    [Human, Copy, The, Colour, AbstractDescription, NTimes],
    [Human, Copy, The, Size, AbstractDescription, NTimes],
    [Human, Copy, The, Size, Colour, AbstractDescription, NTimes],

    [Human, Copy, BlockObjectThat, AbstractDescription, NTimes],
    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, NTimes],
    [Human, Copy, BlockObjectThat, Size, AbstractDescription, NTimes],
    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, NTimes],

    [Human, Copy, BlockObjectThis, NTimes],
    [Human, Copy, BlockObjectThis, AbstractDescription, NTimes],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, NTimes],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, NTimes],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, NTimes],

    [Human, Copy, BlockObjectIt, NTimes],

    # Concrete #
    [Human, Copy, The, ConcreteDescription, NTimes],
    [Human, Copy, The, Colour, ConcreteDescription, NTimes],
    [Human, Copy, The, Size, ConcreteDescription, NTimes],
    [Human, Copy, The, Size, Colour, ConcreteDescription, NTimes],

    [Human, Copy, BlockObjectThat, NTimes],
    [Human, Copy, BlockObjectThose, NTimes],
    [Human, Copy, BlockObjectThese, NTimes],
    [Human, Copy, BlockObjectThat, ConcreteDescription, NTimes],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, NTimes],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, NTimes],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, NTimes],

    [Human, Copy, BlockObjectThis, ConcreteDescription, NTimes],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, NTimes],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, NTimes],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, NTimes],

    ## Copy n of X ##
    # Abstract #
    [Human, Copy, RepeatCount, AbstractDescription],
    [Human, Copy, RepeatCount, Colour, AbstractDescription],
    [Human, Copy, RepeatCount, Size, AbstractDescription],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription],

    [Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription],

    # Concrete #
    [Human, Copy, RepeatCount, ConcreteDescription],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription],
    [Human, Copy, RepeatCount, Size, ConcreteDescription],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription],

    [Human, Copy, BlockObjectThose, RepeatCount],
    [Human, Copy, BlockObjectThese, RepeatCount],
    [Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription],

    # Copy n of X at Location ##
    # Abstract #
    [Human, Copy, RepeatCount, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatCount, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatCount, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, RepeatCount, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatCount, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatCount, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, RepeatCount, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatCount, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatCount, Size, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription, ThereTemplate],

    [Human, Copy, RepeatCount, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatCount, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatCount, Size, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription, ThereTemplateCoref],

    [Human, Copy, RepeatCount, AbstractDescription, HereTemplate],
    [Human, Copy, RepeatCount, Colour, AbstractDescription, HereTemplate],
    [Human, Copy, RepeatCount, Size, AbstractDescription, HereTemplate],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription, HereTemplate],

    [Human, Copy, RepeatCount, AbstractDescription, HereTemplateCoref],
    [Human, Copy, RepeatCount, Colour, AbstractDescription, HereTemplateCoref],
    [Human, Copy, RepeatCount, Size, AbstractDescription, HereTemplateCoref],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription, HereTemplateCoref],

    [Human, Copy, RepeatCount, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatCount, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatCount, Size, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription, YouTemplate],

    [Human, Copy, BlockObjectThat, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThose, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThese, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThose, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThese, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, ThereTemplate],
    [Human, Copy, BlockObjectThose, ThereTemplate],
    [Human, Copy, BlockObjectThese, ThereTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription, ThereTemplate],

    [Human, Copy, BlockObjectThat, ThereTemplateCoref],
    [Human, Copy, BlockObjectThose, ThereTemplateCoref],
    [Human, Copy, BlockObjectThese, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription, ThereTemplateCoref],

    [Human, Copy, BlockObjectThat, YouTemplate],
    [Human, Copy, BlockObjectThese, YouTemplate],
    [Human, Copy, BlockObjectThose, YouTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, AbstractDescription, YouTemplate],

    # Concrete #
    [Human, Copy, RepeatCount, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatCount, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, RepeatCount, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatCount, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, RepeatCount, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatCount, Size, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription, ThereTemplate],

    [Human, Copy, RepeatCount, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatCount, Size, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, RepeatCount, ConcreteDescription, HereTemplate],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription, HereTemplate],
    [Human, Copy, RepeatCount, Size, ConcreteDescription, HereTemplate],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription, HereTemplate],

    [Human, Copy, RepeatCount, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, RepeatCount, Size, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription, HereTemplateCoref],

    [Human, Copy, RepeatCount, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatCount, Size, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription, YouTemplate],

    [Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, RepeatCount, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription, ThereTemplate],

    [Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription, YouTemplate],

    ## Copy all X ##
    # Abstract #
    [Human, Copy, RepeatAll, AbstractDescription],
    [Human, Copy, RepeatAll, Colour, AbstractDescription],
    [Human, Copy, RepeatAll, Size, AbstractDescription],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription],

    [Human, Copy, RepeatAll, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThose],
    [Human, Copy, RepeatAll, BlockObjectThese],
    [Human, Copy, RepeatAll, BlockObjectThat, AbstractDescription],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, AbstractDescription],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, AbstractDescription],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, AbstractDescription],

    # Concrete #
    [Human, Copy, RepeatAll, ConcreteDescription],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription],
    [Human, Copy, RepeatAll, Size, ConcreteDescription],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription],

    [Human, Copy, RepeatAll, BlockObjectThat, ConcreteDescription],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, ConcreteDescription],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, ConcreteDescription],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, ConcreteDescription],

    # Copy all X at Location ##
    # Abstract #
    [Human, Copy, RepeatAll, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, RepeatAll, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, RepeatAll, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatAll, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatAll, Size, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription, ThereTemplate],

    [Human, Copy, RepeatAll, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, Size, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription, ThereTemplateCoref],

    [Human, Copy, RepeatAll, AbstractDescription, HereTemplate],
    [Human, Copy, RepeatAll, Colour, AbstractDescription, HereTemplate],
    [Human, Copy, RepeatAll, Size, AbstractDescription, HereTemplate],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription, HereTemplate],

    [Human, Copy, RepeatAll, AbstractDescription, HereTemplateCoref],
    [Human, Copy, RepeatAll, Colour, AbstractDescription, HereTemplateCoref],
    [Human, Copy, RepeatAll, Size, AbstractDescription, HereTemplateCoref],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription, HereTemplateCoref],

    [Human, Copy, RepeatAll, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatAll, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatAll, Size, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription, YouTemplate],

    [Human, Copy, RepeatAll, BlockObjectThat, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThose, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThese, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, RepeatAll, BlockObjectThat, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThose, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThese, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, RepeatAll, BlockObjectThat, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThose, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThese, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, AbstractDescription, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, AbstractDescription, ThereTemplate],

    [Human, Copy, RepeatAll, BlockObjectThat, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThose, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThese, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThat, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, AbstractDescription, ThereTemplateCoref],

    [Human, Copy, RepeatAll, BlockObjectThat, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThose, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThese, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, AbstractDescription, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, AbstractDescription, YouTemplate],
    # Concrete #
    [Human, Copy, RepeatAll, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, RepeatAll, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, RepeatAll, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatAll, Size, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription, ThereTemplate],

    [Human, Copy, RepeatAll, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, Size, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, RepeatAll, ConcreteDescription, HereTemplate],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription, HereTemplate],
    [Human, Copy, RepeatAll, Size, ConcreteDescription, HereTemplate],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription, HereTemplate],

    [Human, Copy, RepeatAll, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, RepeatAll, Size, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription, HereTemplateCoref],

    [Human, Copy, RepeatAll, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatAll, Size, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription, YouTemplate],

    [Human, Copy, RepeatAll, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, RepeatAll, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, RepeatAll, BlockObjectThat, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, ConcreteDescription, ThereTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, ConcreteDescription, ThereTemplate],

    [Human, Copy, RepeatAll, BlockObjectThat, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, RepeatAll, BlockObjectThat, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, ConcreteDescription, YouTemplate],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, ConcreteDescription, YouTemplate],

    ## Make n copies of X ##
    # Abstract #
    [Human, CopyMultiple, The, AbstractDescription],
    [Human, CopyMultiple, The, Colour, AbstractDescription],
    [Human, CopyMultiple, The, Size, AbstractDescription],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription],

    [Human, CopyMultiple, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThese],
    [Human, CopyMultiple, BlockObjectThose],
    [Human, CopyMultiple, BlockObjectThat, AbstractDescription],
    [Human, CopyMultiple, BlockObjectThat, Colour, AbstractDescription],
    [Human, CopyMultiple, BlockObjectThat, Size, AbstractDescription],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, AbstractDescription],

    [Human, CopyMultiple, BlockObjectThis],
    [Human, CopyMultiple, BlockObjectIt],
    [Human, CopyMultiple, BlockObjectThis, AbstractDescription],
    [Human, CopyMultiple, BlockObjectThis, Colour, AbstractDescription],
    [Human, CopyMultiple, BlockObjectThis, Size, AbstractDescription],
    [Human, CopyMultiple, BlockObjectThis, Size, Colour, AbstractDescription],

    # Concrete #
    [Human, CopyMultiple, The, ConcreteDescription],
    [Human, CopyMultiple, The, Colour, ConcreteDescription],
    [Human, CopyMultiple, The, Size, ConcreteDescription],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription],

    [Human, CopyMultiple, BlockObjectThat, ConcreteDescription],
    [Human, CopyMultiple, BlockObjectThat, Colour, ConcreteDescription],
    [Human, CopyMultiple, BlockObjectThat, Size, ConcreteDescription],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, ConcreteDescription],

    [Human, CopyMultiple, BlockObjectThis, ConcreteDescription],
    [Human, CopyMultiple, BlockObjectThis, Colour, ConcreteDescription],
    [Human, CopyMultiple, BlockObjectThis, Size, ConcreteDescription],
    [Human, CopyMultiple, BlockObjectThis, Size, Colour, ConcreteDescription],

    # Make n copies of X at location ##
    # Abstract #
    [Human, CopyMultiple, The, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, The, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, The, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, CopyMultiple, The, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, The, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, The, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, CopyMultiple, The, AbstractDescription, ThereTemplate],
    [Human, CopyMultiple, The, Colour, AbstractDescription, ThereTemplate],
    [Human, CopyMultiple, The, Size, AbstractDescription, ThereTemplate],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription, ThereTemplate],

    [Human, CopyMultiple, The, AbstractDescription, ThereTemplateCoref],
    [Human, CopyMultiple, The, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, CopyMultiple, The, Size, AbstractDescription, ThereTemplateCoref],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription, ThereTemplateCoref],

    [Human, CopyMultiple, The, AbstractDescription, HereTemplate],
    [Human, CopyMultiple, The, Colour, AbstractDescription, HereTemplate],
    [Human, CopyMultiple, The, Size, AbstractDescription, HereTemplate],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription, HereTemplate],

    [Human, CopyMultiple, The, AbstractDescription, HereTemplateCoref],
    [Human, CopyMultiple, The, Colour, AbstractDescription, HereTemplateCoref],
    [Human, CopyMultiple, The, Size, AbstractDescription, HereTemplateCoref],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription, HereTemplateCoref],

    [Human, CopyMultiple, The, AbstractDescription, YouTemplate],
    [Human, CopyMultiple, The, Colour, AbstractDescription, YouTemplate],
    [Human, CopyMultiple, The, Size, AbstractDescription, YouTemplate],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription, YouTemplate],

    [Human, CopyMultiple, BlockObjectThat, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThese, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThose, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, CopyMultiple, BlockObjectThat, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThese, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThose, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, CopyMultiple, BlockObjectThat, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThose, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThese, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThat, AbstractDescription, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThat, Colour, AbstractDescription, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, AbstractDescription, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, AbstractDescription, ThereTemplate],

    [Human, CopyMultiple, BlockObjectThat, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThose, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThese, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThat, AbstractDescription, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThat, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThat, Size, AbstractDescription, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, AbstractDescription, ThereTemplateCoref],

    [Human, CopyMultiple, BlockObjectThis, HereTemplate],
    [Human, CopyMultiple, BlockObjectThis, AbstractDescription, HereTemplate],
    [Human, CopyMultiple, BlockObjectThis, Colour, AbstractDescription, HereTemplate],
    [Human, CopyMultiple, BlockObjectThis, Size, AbstractDescription, HereTemplate],
    [Human, CopyMultiple, BlockObjectThis, Size, Colour, AbstractDescription, HereTemplate],

    [Human, CopyMultiple, BlockObjectThis, HereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThis, AbstractDescription, HereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThis, Colour, AbstractDescription, HereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThis, Size, AbstractDescription, HereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThis, Size, Colour, AbstractDescription, HereTemplateCoref],

    [Human, CopyMultiple, BlockObjectThat, YouTemplate],
    [Human, CopyMultiple, BlockObjectThose, YouTemplate],
    [Human, CopyMultiple, BlockObjectThese, YouTemplate],
    [Human, CopyMultiple, BlockObjectThat, AbstractDescription, YouTemplate],
    [Human, CopyMultiple, BlockObjectThat, Colour, AbstractDescription, YouTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, AbstractDescription, YouTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, AbstractDescription, YouTemplate],

    # Concrete #
    [Human, CopyMultiple, The, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, The, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, The, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, CopyMultiple, The, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, The, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, The, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, CopyMultiple, The, ConcreteDescription, ThereTemplate],
    [Human, CopyMultiple, The, Colour, ConcreteDescription, ThereTemplate],
    [Human, CopyMultiple, The, Size, ConcreteDescription, ThereTemplate],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription, ThereTemplate],

    [Human, CopyMultiple, The, ConcreteDescription, ThereTemplateCoref],
    [Human, CopyMultiple, The, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, CopyMultiple, The, Size, ConcreteDescription, ThereTemplateCoref],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription, ThereTemplateCoref],

    [Human, CopyMultiple, The, ConcreteDescription, HereTemplate],
    [Human, CopyMultiple, The, Colour, ConcreteDescription, HereTemplate],
    [Human, CopyMultiple, The, Size, ConcreteDescription, HereTemplate],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription, HereTemplate],

    [Human, CopyMultiple, The, ConcreteDescription, HereTemplateCoref],
    [Human, CopyMultiple, The, Colour, ConcreteDescription, HereTemplateCoref],
    [Human, CopyMultiple, The, Size, ConcreteDescription, HereTemplateCoref],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription, HereTemplateCoref],

    [Human, CopyMultiple, The, ConcreteDescription, YouTemplate],
    [Human, CopyMultiple, The, Colour, ConcreteDescription, YouTemplate],
    [Human, CopyMultiple, The, Size, ConcreteDescription, YouTemplate],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription, YouTemplate],

    [Human, CopyMultiple, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, CopyMultiple, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, CopyMultiple, BlockObjectThat, ConcreteDescription, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThat, Colour, ConcreteDescription, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, ConcreteDescription, ThereTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, ConcreteDescription, ThereTemplate],

    [Human, CopyMultiple, BlockObjectThat, ConcreteDescription, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThat, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThat, Size, ConcreteDescription, ThereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, ConcreteDescription, ThereTemplateCoref],

    [Human, CopyMultiple, BlockObjectThis, ConcreteDescription, HereTemplate],
    [Human, CopyMultiple, BlockObjectThis, Colour, ConcreteDescription, HereTemplate],
    [Human, CopyMultiple, BlockObjectThis, Size, ConcreteDescription, HereTemplate],
    [Human, CopyMultiple, BlockObjectThis, Size, Colour, ConcreteDescription, HereTemplate],

    [Human, CopyMultiple, BlockObjectThis, ConcreteDescription, HereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThis, Colour, ConcreteDescription, HereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThis, Size, ConcreteDescription, HereTemplateCoref],
    [Human, CopyMultiple, BlockObjectThis, Size, Colour, ConcreteDescription, HereTemplateCoref],

    [Human, CopyMultiple, BlockObjectThat, ConcreteDescription, YouTemplate],
    [Human, CopyMultiple, BlockObjectThat, Colour, ConcreteDescription, YouTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, ConcreteDescription, YouTemplate],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, ConcreteDescription, YouTemplate],

    ## Single word copy command ##
    [Human, CopySingle],

    ## Copy X ##
    [Human, Copy, BlockObjectThat],
    [Human, Copy, BlockObjectThese],
    [Human, Copy, BlockObjectThose],
    [Human, Copy, BlockObjectThis],
    [Human, Copy, BlockObjectIt],

    [Human, Copy, BlockObjectThat, AbstractDescription],
    [Human, Copy, BlockObjectThis, AbstractDescription],
    [Human, Copy, BlockObjectThat, ConcreteDescription],
    [Human, Copy, BlockObjectThis, ConcreteDescription],
    [Human, Copy, The, AbstractDescription],
    [Human, Copy, The, ConcreteDescription],
    [Human, Copy, ConcreteDescription],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription],
    [Human, Copy, The, Colour, AbstractDescription],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription],
    [Human, Copy, The, Colour, ConcreteDescription],

    [Human, Copy, BlockObjectThat, AbstractDescription],
    [Human, Copy, BlockObjectThis, AbstractDescription],
    [Human, Copy, BlockObjectThat, ConcreteDescription],
    [Human, Copy, BlockObjectThis, ConcreteDescription],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription],
    [Human, Copy, The, Size, AbstractDescription],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription],
    [Human, Copy, The, Size, ConcreteDescription],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription],
    [Human, Copy, The, Size, Colour, AbstractDescription],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription],
    [Human, Copy, The, Size, Colour, ConcreteDescription],

    ## Copy X to location Y ##
    [Human, Copy, BlockObjectThat, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectIt, At, LocationWord, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, The, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, The, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, ConcreteDescription, At, LocationWord, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, The, Colour, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, At, LocationWord, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, At, LocationWord, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, The, Size, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, The, Size, ConcreteDescription, At, LocationWord, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, At, LocationWord, CoordinatesTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, At, LocationWord, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectIt, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Colour, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThis, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectIt, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectIt, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThis, ThereTemplate],
    [Human, Copy, BlockObjectIt, ThereTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ThereTemplate],
    [Human, Copy, The, AbstractDescription, ThereTemplate],
    [Human, Copy, The, ConcreteDescription, ThereTemplate],
    [Human, Copy, ConcreteDescription, ThereTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, The, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, ThereTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, ThereTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ThereTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, ThereTemplate],
    [Human, Copy, The, Size, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, ThereTemplate],
    [Human, Copy, The, Size, ConcreteDescription, ThereTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, ThereTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, ThereTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, ThereTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, ThereTemplate],

    [Human, Copy, BlockObjectThis, ThereTemplateCoref],
    [Human, Copy, BlockObjectIt, ThereTemplateCoref],

    [Human, Copy, BlockObjectThat, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, The, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, The, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, The, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, The, Colour, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, BlockObjectThat, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, The, Size, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, The, Size, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, The, Size, Colour, AbstractDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, ThereTemplateCoref],
    [Human, Copy, The, Size, Colour, ConcreteDescription, ThereTemplateCoref],

    [Human, Copy, BlockObjectThat, HereTemplate],
    [Human, Copy, BlockObjectThis, HereTemplate],
    [Human, Copy, BlockObjectIt, HereTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, HereTemplate],
    [Human, Copy, The, AbstractDescription, HereTemplate],
    [Human, Copy, The, ConcreteDescription, HereTemplate],
    [Human, Copy, ConcreteDescription, HereTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, HereTemplate],
    [Human, Copy, The, Colour, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, HereTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, HereTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, HereTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, HereTemplate],
    [Human, Copy, The, Size, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, HereTemplate],
    [Human, Copy, The, Size, ConcreteDescription, HereTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, HereTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, HereTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, HereTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, HereTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, HereTemplate],

    [Human, Copy, BlockObjectThat, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, HereTemplateCoref],
    [Human, Copy, BlockObjectIt, HereTemplateCoref],

    [Human, Copy, BlockObjectThat, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThat, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, The, AbstractDescription, HereTemplateCoref],
    [Human, Copy, The, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, ConcreteDescription, HereTemplateCoref],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, HereTemplateCoref],
    [Human, Copy, The, Colour, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, The, Colour, ConcreteDescription, HereTemplateCoref],

    [Human, Copy, BlockObjectThat, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThat, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, ConcreteDescription, HereTemplateCoref],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, HereTemplateCoref],
    [Human, Copy, The, Size, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, The, Size, ConcreteDescription, HereTemplateCoref],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, HereTemplateCoref],
    [Human, Copy, The, Size, Colour, AbstractDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, HereTemplateCoref],
    [Human, Copy, The, Size, Colour, ConcreteDescription, HereTemplateCoref],

    [Human, Copy, BlockObjectThis, YouTemplate],
    [Human, Copy, BlockObjectIt, YouTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, YouTemplate],
    [Human, Copy, The, AbstractDescription, YouTemplate],
    [Human, Copy, The, ConcreteDescription, YouTemplate],
    [Human, Copy, ConcreteDescription, YouTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, The, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, YouTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, YouTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, YouTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, YouTemplate],
    [Human, Copy, The, Size, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, YouTemplate],
    [Human, Copy, The, Size, ConcreteDescription, YouTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, YouTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, YouTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, YouTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, YouTemplate],

    [Human, Copy, BlockObjectThat, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectIt, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectIt, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectIt, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectIt, ALittle, RelativeDirectionTemplate, YouTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, The, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, The, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, The, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, The, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, The, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, YouTemplate],

    [Human, Copy, BlockObjectThat, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectIt, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationBlockObjectTemplate],

    [Human, Copy, BlockObjectThat, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectIt, ALittle, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, LocationMobTemplate],

    [Human, Copy, BlockObjectThat, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectIt, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],
    [Human, Copy, The, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, CoordinatesTemplate],

    ## rel_dir of BlockObjectThat templates ##

    [Human, Copy, RepeatCount, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatCount, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatCount, Size, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatCount, Size, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, RepeatCount, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatCount, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatCount, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatCount, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, RepeatCount, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, RepeatCount, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, RepeatCount, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, RepeatAll, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, Size, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, Size, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, RepeatAll, BlockObjectThat, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThose, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThese, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, RepeatAll, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, RepeatAll, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, RepeatAll, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, CopyMultiple, The, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, The, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, The, Size, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, The, Size, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, CopyMultiple, BlockObjectThat, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThese, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThose, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, CopyMultiple, The, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, The, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, The, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, The, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, CopyMultiple, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, CopyMultiple, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectIt, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, Colour, AbstractDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, Colour, ConcreteDescription, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectIt, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, Colour, AbstractDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, Colour, ConcreteDescription, StepsTemplate, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectIt, ALittle, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],

    [Human, Copy, BlockObjectThat, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, Colour, AbstractDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThat, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, BlockObjectThis, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat],
    [Human, Copy, The, Size, Colour, ConcreteDescription, ALittle, RelativeDirectionTemplate, BlockObjectThat]

    ] + COPY_WITH_CORRECTION
