require('game/managers/Content');

function RareLootContent() {
}

RareLootContent.contentId = function() {
  return 'world#RareLoot';
};

RareLootContent.checkItem = function(itemShouldExist, flagName, mapId, x, y, itemId, amount) {
  if (itemShouldExist) {
    if (!$gameSystem['_rareLoot_' + flagName]) {
      $gameSystem['_rareLoot_' + flagName] = true;
      var item = Managers.FarmObjects.createItemAt(mapId, x, y, itemId, amount);
      item.updateEvents(false, false);
    }
  } else {
    if ($gameSystem['_rareLoot_' + flagName]) {
      delete $gameSystem['_rareLoot_' + flagName];
      Managers.FarmObjects.eraseFarmObjectsXy(mapId, x, y);
    }
  }

};

RareLootContent.setupMapEvents = function(firstOfTheDay) {
  var silverOre = Managers.Time.weekDay == Days.TUESDAY && Managers.Time.isBetweenTimes('10:22', '10:51');

  RareLootContent.checkItem(silverOre, 'southMountain', Maps.MOUNTAIN, 11, 62, 'silver-ore');
};

Managers.Content.registerContentClass(RareLootContent);