const BaseWildAnimal = require('./BaseWildAnimal');

class ForestMonkey extends BaseWildAnimal {
  static getAnimalName() {
    return 'ForestMonkey';
  }

  static validMaps() {
    return [
      Maps.FOREST,
    ];
  }

  static chat(methods) {
    // Player "It's a monkey"
  }

  static getCurrentSchedule() {
    if (!Switches.unlockedMonkeys) {
      return 'disabled';
    }

    if (Managers.Weather.isBadWeather()) {
      return 'disabled';
    }

    if (Managers.Time.month === Seasons.WINTER) {
      return 'disabled';
    }

    return 'default';
  }
}

ForestMonkey.register();
module.exports = ForestMonkey;