require('game/managers/Content');
const ForestMonkey = require('./ForestMonkey');
const SummerMonkey = require('./SummerMonkey');

const monkeys = {
  ForestMonkey,
  SummerMonkey,
};

const allWildAnimals = {
  ...monkeys,
};

class WildAnimalsContent {
  static contentId() {
    return 'wild-animals';
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName in allWildAnimals) {
      const obj = allWildAnimals[villagerName];
      if (obj && obj.getCurrentSchedule) {
        return obj.getCurrentSchedule();
      }
    }
  }

  static getVillagerClassType(villagerName) {
    if (villagerName in monkeys) {
      return Objects.Monkey;
    }
  }
}

Managers.Content.registerContentClass(WildAnimalsContent);
