class BaseVillager {
  static getVillagerName() {
    return 'invisible-man';
  }

  static validMaps() {
    return [
    ];
  }

  static isValidMap() {
    const validMaps = this.validMaps();
    return (validMaps.indexOf($gameMap._mapId) >= 0);
  }

  static checkIfVillagerShouldLeaveParty() {

  }

  static onChangeTime() {
    if (Managers.Villagers.isVillagerOnParty(this.getVillagerName())) {
      this.checkIfVillagerShouldLeaveParty();
    } else {
      if (!this.isValidMap()) return;

      Managers.Villagers.runVillagerTimedEvents(this.getVillagerName());
    }
  }

  static onUpdateVillagers() {
    if (!this.isValidMap()) return;
    if ($gameMap.isInsideAnyHouse()) return;

    Managers.Villagers.createVillagerOnScheduledPosition(this.getVillagerName());
  }

  static onSetupMapEvents() {
    if (!this.isValidMap()) return;

    Managers.Villagers.createVillagerOnScheduledPosition(this.getVillagerName());
  }

  static openDoor() {
    $gameMap.openVillagerDoor(this.getVillagerName());
  }

  static closeDoor() {
    $gameMap.closeVillagerDoor(this.getVillagerName());
  }

  static chat(methods) {
    const { play } = methods;

    return play(`${ this.getVillagerName() }_default`);
  }

  static register() {
    Managers.Time.on('changeTime', this.onChangeTime.bind(this));
    Managers.Map.on('setupMapEvents', this.onSetupMapEvents.bind(this));
    Managers.Map.on('updateVillagers', this.onUpdateVillagers.bind(this));
  }
}

module.exports = BaseVillager;