const BaseVillager = require('../_system/BaseVillager');

class Viktor extends BaseVillager {
  static getVillagerName() {
    return 'Viktor';
  }

  static validMaps() {
    return [
      Maps.BLACKSMITH,
      Maps.BLACKSMITH_ROOMS,
      Maps.ORANGE_TOWN,
      Maps.LIBRARY
    ];
  }

  static checkIfVillagerShouldLeaveParty() {
    if (Managers.Time.isBetweenTimes('21:00', '23:59') || Managers.Time.isBetweenTimes('00:00', '06:59')) {
      Managers.CommonEvent.playEvent('viktor_leave_party_to_sleep');
      return;
    }
  }

  static openChain() {
    $gameMap.openVillagerDoor('Blacksmith', false);
  }

  static closeChain() {
    $gameMap.closeVillagerDoor('Blacksmith', false);
  }

  static chat(methods) {
    const { play, playDuringOneDayOnly, playOnePerWeekDay, playBestEvent, playOneDayPerMonth } = methods;
    // #ToDo: Companion

    const sequentialChats = () => {
      if (!Switches.unlockedViktorEvents) {
        if (playDuringOneDayOnly('viktor_sequential_1')) return true;
        if (playDuringOneDayOnly('viktor_sequential_2')) return true;
        if (playDuringOneDayOnly('viktor_sequential_3')) return true;
        if (playDuringOneDayOnly('viktor_sequential_4')) return true;
        if (playDuringOneDayOnly('viktor_sequential_5')) return true;
        if (playDuringOneDayOnly('viktor_sequential_6')) return true;
        if (playDuringOneDayOnly('viktor_sequential_7')) return true;
        if (playDuringOneDayOnly('viktor_sequential_8')) return true;
        if (playDuringOneDayOnly('viktor_sequential_9')) return true;
        if (playDuringOneDayOnly('viktor_sequential_10')) return true;
        Switches.unlockedViktorEvents = true;
      }
      return false;
    };

    if (sequentialChats()) return;

    if (Switches.playedOldHorseCartEvent && !Switches.playedOldHorseCartEvent2 && !$gameParty.hasCompanion()) {
      return play('viktor_old_horsecart_event');
    }

    if (Managers.Time.yearDay === Festivals.CANDY - 1) {
      return play('viktor_candy_day_tomorrow');
    }

    if (Managers.Time.yearDay === Festivals.CANDY) {
      return play('viktor_candy_day');
    }

    if (Managers.Time.yearDay == Birthdays.RICHARD) {
      return play('viktor_richard_birthday');
    }

    if (Switches.viktorIsLookingForSugarcanes && !Managers.Tasks.isTaskKnown('viktor-sugarcanes')) {
      return play('viktor_ask_for_sugarcanes');
    }

    const tools = [];
    if (!Switches.hasIronSickle) {
      tools.push('viktor_sickle');
    }
    if (!Switches.hasIronAxe && !Switches.hasBrokenAxe){
      tools.push('viktor_axe');
    }
    if (!Switches.hasIronHammer) {
      tools.push('viktor_hammer');
    }

    if (tools.length) {
      if (playBestEvent(tools, 0, false, true)) return;
    }

    if (playOneDayPerMonth(['viktor_1', 'viktor_2', 'viktor_3'])) return;

    if (playOnePerWeekDay(
      [
        'viktor_weekly_sunday',
        'viktor_weekly_monday',
        'viktor_weekly_tuesday',
        'viktor_weekly_wednesday',
        'viktor_weekly_thursday',
        'viktor_weekly_friday',
        'viktor_weekly_saturday'
      ])) {
      return;
    }

    return play('viktor_default');
  }
}

Viktor.register();
module.exports = Viktor;
