const Viktor = require('./Viktor');

class ViktorContent {
  static contentId() {
    return 'viktor';
  }

  static isVillagerBridgesBurned(villagerName) {
    if (villagerName.toLowerCase() !== 'viktor') return;

    return Switches.burnedBridgesWithViktor;
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'VIKTOR') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Viktor.openDoor();
        return true;
      case 'CLOSEDOOR':
        Viktor.closeDoor();
        return true;
      case 'OPENCHAIN':
        Viktor.openChain();
        return true;
      case 'CLOSECHAIN':
        Viktor.closeChain();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Viktor', parser.interpreter);
          Viktor.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Viktor') return;

    return true;
  }

  static processNewDay() {
    this.reEnableSugarcaneTask();
  }

  static checkCutscenes(mapId) {
    if ($gamePlayer.isRiding()) return false;
    if (!Managers.Relationship.isCharacterKnown('Viktor')) return false;

    if (this.checkCutsceneViktorDate1(mapId)) return true;
    if (this.checkCutsceneViktorDate2(mapId)) return true;
    
    return false;
  }



  static reEnableSugarcaneTask() {
    // Every year on the fourth day of spring, there's a new chance to accept this task

    if (Managers.Time.year == 1) return;
    if (Managers.Time.month != Seasons.SPRING) return;
    if (Managers.Time.day != 4) return;

    if (Switches.viktorIsLookingForSugarcanes) return;

    if (!Switches.unlockedStellaEvents) {
      if (!Managers.History.wasConversationEverPlayed('stella_sequential_3')) {
        return false;
      }
    }

    if (Managers.Tasks.isTaskKnown('viktor-sugarcanes')) return;

    Switches.viktorIsLookingForSugarcanes = true;
  }

  static checkCutsceneViktorDate1(mapId) {
    if (Switches.playedViktorFirstDate) return false;
    
    if (mapId !== Maps.RESTAURANT) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;
    if (!Switches.unlockedViktorEvents) return false;

    if (Managers.Time.weekDay < Days.FRIDAY || Managers.Time.weekDay > Days.SATURDAY) return false;

    if (!$gameParty.isVillagerOnParty('Viktor')) return false;
    if (Managers.Time.hour < 17) return false;
    if (Managers.Time.hour >= 20) return false;
    if (Managers.Relationship.getHeartsNum('Viktor') < 2) return false;

    Managers.Time.hour = 20;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 8, 13, Direction.UP, 0, false);
    $gameParty.removeVillager('Viktor');
    $gameTemp.reserveCutscene('viktor_first_date');
    return true;
  }

  static checkCutsceneViktorDate2(mapId) {
    if (Switches.playedViktorSecondDate) return false;
    if (!Switches.playedViktorFirstDate) return false;
    if (!Switches.unlockedViktorEvents) return false;
    
    if (mapId !== Maps.RESTAURANT) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (Managers.Time.weekDay < Days.FRIDAY || Managers.Time.weekDay > Days.SATURDAY) return false;

    if (!$gameParty.isVillagerOnParty('Viktor')) return false;
    if (Managers.Time.hour < 17) return false;
    if (Managers.Time.hour >= 20) return false;
    if (Managers.Relationship.getHeartsNum('Viktor') < 3) return false;

    Managers.Time.hour = 20;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 8, 13, Direction.UP, 0, false);
    $gameParty.removeVillager('Viktor');
    $gameTemp.reserveCutscene('viktor_second_date');
    return true;
  }
}

Managers.Content.registerContentClass(ViktorContent);