const BaseVillager = require('../_system/BaseVillager');

class Thalia extends BaseVillager {
  static getVillagerName() {
    return 'Thalia';
  }

  static validMaps() {
    return [
      Maps.INN,
      Maps.RESTAURANT,
      Maps.ORANGE_TOWN
    ];
  }

  static chat(methods) {
    const { play } = methods;

    if (Managers.Time.isBetweenTimes('00:00', '06:15')) {
      return play('thalia_default');
    }

    if (Managers.Time.isBetweenTimes('06:16', '10:52')) {
      return play('thalia_morning');
    }

    if (Managers.Time.isBetweenTimes('10:53', '13:09')) {
      return play('thalia_good_things');
    }

    if (Managers.Time.isBetweenTimes('13:10', '21:58') && !Switches.skipMapStore) {
      return play('thalia_spa');
    }

    if (Managers.Time.isBetweenTimes('21:59', '23:59')) {
      return play('thalia_night');
    }

    return play('thalia_default');
  }

  static openSpa() {
    $gameMap.openVillagerDoor('SPA', false);
  }

  static closeSpa() {
    $gameMap.closeVillagerDoor('SPA', false);
  }
}

Thalia.register();
module.exports = Thalia;
