const Thalia = require('./Thalia');

class ThaliaContent {
  static contentId() {
    return 'thalia';
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'thalia') return;

    return 'default';
  }


  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'THALIA') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENSPA':
        if (parser.nextUpperArg() === 'NOW') {
          const event = $gameMap.getVillagerDoorEvent('SPA');
          if (event) {
            event._direction = Direction.UP;
          }
        } else {
          Thalia.openSpa();
        }
        return true;
      case 'CLOSESPA':
        Thalia.closeSpa();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Thalia', parser.interpreter);
          Thalia.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(ThaliaContent);

