const BaseVillager = require('../_system/BaseVillager');

class Stella extends BaseVillager {
  static getVillagerName() {
    return 'Stella';
  }

  static validMaps() {
    return [
      Maps.BRITTANYS_FARM,
      Maps.ORANGE_TOWN
    ];
  }

  static openDoor() {
    $gameMap.openVillagerDoor('Brittany');
  }

  static closeDoor() {
    $gameMap.closeVillagerDoor('Brittany');
  }

  static openBarnDoor() {
    $gameMap.openMapDoor(Maps.ORANGE_TOWN, 175);
  }

  static closeBarnDoor() {
    $gameMap.closeMapDoor(Maps.ORANGE_TOWN, 175);
  }

  static chat(methods) {
    const { play, playDuringOneDayOnly, playOnePerWeekDay } = methods;
    // #ToDo: Companion

    const sequentialChats = () => {
      if (!Switches.unlockedStellaEvents) {
        if (playDuringOneDayOnly('stella_sequential_1')) return true;
        if (playDuringOneDayOnly('stella_sequential_2')) return true;
        if (playDuringOneDayOnly('stella_sequential_3')) return true;
        if (playDuringOneDayOnly('stella_sequential_4')) return true;
        if (playDuringOneDayOnly('stella_sequential_5')) return true;
        if (playDuringOneDayOnly('stella_sequential_6')) return true;
        if (playDuringOneDayOnly('stella_sequential_7')) return true;
        if (playDuringOneDayOnly('stella_sequential_8')) return true;
        if (playDuringOneDayOnly('stella_sequential_9')) return true;
        if (playDuringOneDayOnly('stella_sequential_10')) return true;
        Switches.unlockedStellaEvents = true;
      }
      return false;
    };

    if (sequentialChats()) return;

    if (Switches.isCandyFestival) {
      return play('stella_candy_day');
    }

    if (playOnePerWeekDay(
      [
        'stella_weekly_sunday',
        'stella_weekly_monday',
        'stella_weekly_tuesday',
        'stella_weekly_wednesday',
        'stella_weekly_thursday',
        'stella_weekly_friday',
        'stella_weekly_saturday'
      ])) {
      return;
    }

    return play('stella_default');
  }
}

Stella.register();
module.exports = Stella;
