const Stella = require('./Stella');

class StellaContent {
  static contentId() {
    return 'stella';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'STELLA') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Stella.openDoor();
        return true;
      case 'CLOSEDOOR':
        Stella.closeDoor();
        return true;
      case 'OPENBARNDOOR':
        Stella.openBarnDoor();
        return true;
      case 'CLOSEBARNDOOR':
        Stella.closeBarnDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Stella', parser.interpreter);
          Stella.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Stella') return;

    if (!Managers.Time.isBetweenTimes('17:40', '23:59')) {
      return false;
    }

    return true;
  }


  static checkCutscenes(mapId) {
    if ($gamePlayer.isRiding()) return false;
    if (!Managers.Relationship.isCharacterKnown('Stella')) return false;

    if (this.checkCutsceneStellaDate1(mapId)) return true;
    if (this.checkCutsceneStellaDate2(mapId)) return true;
    
    return false;
  }

  static checkCutsceneStellaDate1(mapId) {
    if (Switches.playedStellaFirstDate) return false;
    if (!Switches.unlockedStellaEvents) return false;

    if (mapId !== Maps.RESTAURANT) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (Managers.Time.weekDay < Days.FRIDAY || Managers.Time.weekDay > Days.SATURDAY) return false;

    if (!$gameParty.isVillagerOnParty('Stella')) return false;
    if (Managers.Time.hour < 17) return false;
    if (Managers.Time.hour >= 20) return false;
    if (Managers.Relationship.getHeartsNum('Stella') < 2) return false;

    Managers.Time.hour = 20;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 8, 13, Direction.UP, 0, false);
    $gameParty.removeVillager('Stella');
    $gameTemp.reserveCutscene('stella_first_date');
    return true;
  }

  static checkCutsceneStellaDate2(mapId) {
    if (Switches.playedStellaSecondDate) return false;
    if (!Switches.playedStellaFirstDate) return false;
    if (!Switches.unlockedStellaEvents) return false;

    if (mapId !== Maps.BEACH) return false;
    if ($gameMap._mapId != Maps.PETTING_ZOO) return false;

    if (!$gameParty.isVillagerOnParty('Stella')) return false;
    if (Managers.Time.hour < 18) return false;
    if (Managers.Time.hour >= 20) return false;
    if (Managers.Relationship.getHeartsNum('Stella') < 3) return false;

    Managers.Time.hour = 19;
    Managers.Time.minute = 5;
    Managers.Time.seconds = 9;
    Managers.Time.updateTime();

    // //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 10, 20, Direction.DOWN, 0, false);
    $gameParty.removeVillager('Stella');
    $gameTemp.reserveCutscene('stella_second_date');
    return true;
  }
}

Managers.Content.registerContentClass(StellaContent);