const BaseVillager = require('../_system/BaseVillager');

class Serge extends BaseVillager {
  static getVillagerName() {
    return 'Serge';
  }

  static validMaps() {
    return [
      Maps.GENERAL_STORE,
      Maps.ORANGE_TOWN,
      Maps.BRITTANYS_FARM,
      Maps.RESTAURANT
    ];
  }

  static chat(methods) {
    const { play, playOnceADay, playDuringOneDayOnly, playOnePerWeekDay } = methods;
    
    const sequentialChats = () => {
      if (playDuringOneDayOnly('serge_sequential_1')) return true;
      if (playDuringOneDayOnly('serge_sequential_2')) return true;
      if (playDuringOneDayOnly('serge_sequential_3')) return true;
      if (playDuringOneDayOnly('serge_sequential_4')) return true;
      if (playDuringOneDayOnly('serge_sequential_5')) return true;
      return false;
    };

    if (Managers.Time.yearDay === Festivals.CANDY - 1) {
      return play('serge_candy_day_tomorrow');
    }

    if (Managers.Time.yearDay === Festivals.CANDY) {
      return play('serge_candy_day');
    }

    if (Switches.playedDevinHeartEvent0 && !Switches.playedDevinHeartEvent0B) {
      if (playOnceADay('serge_line_about_devin_cooking')) return;
    }

    if (sequentialChats()) return;

    if (playOnePerWeekDay(
      [
        'serge_weekly_sunday',
        'serge_weekly_monday',
        'serge_weekly_tuesday',
        'serge_weekly_wednesday',
        'serge_weekly_thursday',
        'serge_weekly_friday',
        'serge_weekly_saturday'
      ])) {
      return;
    }

    return play('serge_default');
  }
}

Serge.register();

module.exports = Serge;
