const Serge = require('./Serge');

class SergeContent {
  static contentId() {
    return 'serge';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'SERGE') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Serge.openDoor();
        return true;
      case 'CLOSEDOOR':
        Serge.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Serge', parser.interpreter);
          Serge.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(SergeContent);