const Sarah = require('./Sarah');
let unlockedSarah = false;

class SarahContent {
  static contentId() {
    return 'sarah';
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'sarah') return;

    if (Managers.Time.totalDays < 15) {
      return 'hidden';
    }

    if (!unlockedSarah) {
      return 'not-met';
    }

    if (Switches.expandedHouse && Managers.Time.isBetweenTimes('11:34', '11:35')) {
      if (Switches.builtSecondFloor) {
        return 'default_big_house';
      }
      return 'default_expanded_house';
    }

    return 'default';
  }

  static setupMapEvents() {
    const hadUnlockedSarah = unlockedSarah;
    unlockedSarah = Managers.Relationship.isCharacterKnown('Sarah');

    if (!hadUnlockedSarah && unlockedSarah) {
      // Force refresh, otherwise the character would not be created when loading a game
      Sarah.onSetupMapEvents();
    }
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'SARAH') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Sarah', parser.interpreter);
          Sarah.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(SarahContent);