const Rory = require('./Rory');

class RoryContent {
  static contentId() {
    return 'rory';
  }

  static isVillagerBridgesBurned(villagerName) {
    if (villagerName.toLowerCase() !== 'rory') return;

    return Switches.burnedBridgesWithRory;
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'RORY') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Rory.openDoor();
        return true;
      case 'CLOSEDOOR':
        Rory.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Rory', parser.interpreter);
          Rory.chat(methods);
        }
        return true;
    }
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'rory') return;

    if (Switches.cindyMovedOut) {
      return 'cindyMovedOut';
    }

    return 'default';
  }
}

Managers.Content.registerContentClass(RoryContent);