const BaseVillager = require('../_system/BaseVillager');

class Richard extends BaseVillager {
  static getVillagerName() {
    return 'Richard';
  }

  static validMaps() {
    return [
      Maps.BLACKSMITH,
      Maps.BLACKSMITH_ROOMS,
      Maps.ORANGE_TOWN,
      Maps.RESTAURANT
    ];
  }

  static openDoor() {
    // $gameMap.openVillagerDoor('Viktor');
  }

  static closeDoor() {
    // $gameMap.closeVillagerDoor('Viktor');
  }

  static chat(methods) {
    const { play, playOnePerWeekDay, playOneDayPerWeek, playTwoDaysPerMonth } = methods;

    if (Managers.Time.yearDay == Festivals.CANDY - 2) {
      return play('richard_candy_day_day_after_tomorrow');
    }

    if (Managers.Time.yearDay == Festivals.CANDY - 1) {
      return play('richard_candy_day_tomorrow');
    }

    if (Switches.isCandyFestival && !Switches.gaveCandyToRichard) {
      return play('richard_candy_day');
    }



    if (Managers.Weather.isRaining()) {
      if (playOneDayPerWeek('richard_rain_1')) return;
    }

    if (Managers.Time.hour >= 18) {
      if (playTwoDaysPerMonth([ 'richard_night_1', 'richard_night_2', 'richard_night_3', 'richard_night_4' ])) {
        return;
      }
    } else if (Managers.Time.hour >= 12) {
      if (playTwoDaysPerMonth([ 'richard_afternoon_1', 'richard_afternoon_2', 'richard_afternoon_3', 'richard_afternoon_4' ])) {
        return;
      }
    } else if (Managers.Time.hour >= 5) {
      if (playTwoDaysPerMonth([ 'richard_morning_1', 'richard_morning_2', 'richard_morning_3', 'richard_morning_4' ])) {
        return;
      }
    }

    switch(Managers.Time.month) {
      case Seasons.SPRING:
        if (playTwoDaysPerMonth(['richard_spring_1', 'richard_spring_2', 'richard_spring_3'])) {
          return;
        }
        break;
      case Seasons.SUMMER:
        if (playTwoDaysPerMonth(['richard_summer_1', 'richard_summer_2', 'richard_summer_3'])) {
          return;
        }
        break;
      case Seasons.FALL:
        if (playTwoDaysPerMonth(['richard_fall_1', 'richard_fall_2', 'richard_fall_3'])) {
          return;
        }
        break;
      case Seasons.WINTER:
        if (playTwoDaysPerMonth(['richard_winter_1', 'richard_winter_2', 'richard_winter_3'])) {
          return;
        }
        break;
    }

    if (playTwoDaysPerMonth([ 'richard_daily_1', 'richard_daily_2', 'richard_daily_3' ])) {
      return;
    }

    if (playOnePerWeekDay(
      [
        'richard_weekly_sunday',
        'richard_weekly_monday',
        'richard_weekly_tuesday',
        'richard_weekly_wednesday',
        'richard_weekly_thursday',
        'richard_weekly_friday',
        'richard_weekly_saturday'
      ])) {
      return;
    }

    return play('richard_default');
  }
}

Richard.register();
module.exports = Richard;
