const Richard = require('./Richard');

class RichardContent {
  static contentId() {
    return 'richard';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'RICHARD') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Richard.openDoor();
        return true;
      case 'CLOSEDOOR':
        Richard.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Richard', parser.interpreter);
          Richard.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(RichardContent);