const BaseVillager = require('../_system/BaseVillager');

class Raphael extends BaseVillager {
  static getVillagerName() {
    return 'Raphael';
  }

  static validMaps() {
    return [
      Maps.CARPENTER_HOUSE,
      Maps.ORANGE_TOWN,
      Maps.RESTAURANT,
      Maps.BAR,
      Maps.FARM,
      Maps.GENERAL_STORE
    ];
  }

  static checkIfVillagerShouldLeaveParty() {
    if (Managers.Time.isBetweenTimes('12:30', '21:00')) {
      Managers.CommonEvent.playEvent('raphael_leave_party_to_work');
      return;
    }

    if (Managers.Time.isBetweenTimes('01:00', '06:30')) {
      Managers.CommonEvent.playEvent('raphael_leave_party_to_sleep');
      return;
    }
  }

  static chat(methods) {
    const { play, playOnceADay, playDuringOneDayOnly, playOnePerWeekDay } = methods;
    // #ToDo: Companion

    const sequentialChats = () => {
      if (!Switches.unlockedRaphaelEvents) {
        if (playDuringOneDayOnly('raphael_sequential_1')) return true;
        if (playDuringOneDayOnly('raphael_sequential_2')) return true;
        if (playDuringOneDayOnly('raphael_sequential_3')) return true;
        if (playDuringOneDayOnly('raphael_sequential_4')) return true;
        if (playDuringOneDayOnly('raphael_sequential_5')) return true;
        if (playDuringOneDayOnly('raphael_sequential_6')) return true;
        if (playDuringOneDayOnly('raphael_sequential_7')) return true;
        if (playDuringOneDayOnly('raphael_sequential_8')) return true;
        if (playDuringOneDayOnly('raphael_sequential_9')) return true;
        if (playDuringOneDayOnly('raphael_sequential_10')) return true;
        Switches.unlockedRaphaelEvents = true;
      }

      return false;
    };

    if (sequentialChats()) return;

    if (!Switches.playedOldHorseCartEvent && Switches.canPlayOldHorseCartEvent && !$gameParty.hasCompanion()) {
      return play('raphael_old_horsecart_event');
    }

    if (Managers.Time.yearDay === Festivals.CANDY) {
      if (playOnceADay('raphael_candy_day')) return;
    }

    if (playOnePerWeekDay(
      [
        'raphael_weekly_sunday',
        'raphael_weekly_monday',
        'raphael_weekly_tuesday',
        'raphael_weekly_wednesday',
        'raphael_weekly_thursday',
        'raphael_weekly_friday',
        'raphael_weekly_saturday'
      ])) {
      return;
    }

    return play('raphael_default');
  }
}

Raphael.register();
module.exports = Raphael;
