const Raphael = require('./Raphael');

class RaphaelContent {
  static contentId() {
    return 'raphael';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'RAPHAEL') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Raphael.openDoor();
        return true;
      case 'CLOSEDOOR':
        Raphael.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Raphael', parser.interpreter);
          Raphael.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Raphael') return;

    if (!Managers.Time.isBetweenTimes('06:31', '12:00') && !Managers.Time.isBetweenTimes('21:01', '23:59')) {
      return false;
    }

    return true;
  }

  static checkCutscenes(mapId) {
    if ($gamePlayer.isRiding()) return false;
    if (!Managers.Relationship.isCharacterKnown('Raphael')) return false;

    if ($gameParty.hasCompanion()) {
      if (this.checkCutsceneRaphaelDate1(mapId)) return true;
      if (this.checkCutsceneRaphaelDate2(mapId)) return true;
    } else {
      if (this.checkCutsceneRaphaelWantingGirlfriend(mapId)) return true;

      //This event doesn't trigger any cutscene
      this.checkEventOldHorseCart(mapId);
    }

    return false;
  }

  static checkCutsceneRaphaelDate1(mapId) {
    if (Switches.playedRaphaelFirstDate) return false;
    if (!Switches.playedRaphaelWantingGirlfriend) return false;
    if (!Switches.unlockedRaphaelEvents) return false;

    if (mapId !== Maps.MOUNTAIN) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Raphael')) return false;
    if (Managers.Time.hour < 9) return false;
    if (Managers.Time.hour >= 13) return false;
    if (Managers.Relationship.getHeartsNum('Raphael') < 2) return false;

    Managers.Time.hour = 13;
    Managers.Time.minute = 0;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 70, 73, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Raphael');
    $gameTemp.reserveCutscene('raphael_first_date');
    return true;
  }


  static checkCutsceneRaphaelDate2(mapId) {
    if (Switches.playedRaphaelSecondDate) return false;
    if (!Switches.playedRaphaelFirstDate) return false;
    if (!Switches.unlockedRaphaelEvents) return false;

    if (mapId !== Maps.FOREST) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Raphael')) return false;
    if (Managers.Time.hour < 9) return false;
    if (Managers.Time.hour >= 13) return false;
    if (Managers.Relationship.getHeartsNum('Raphael') < 3) return false;

    Managers.Time.hour = 13;
    Managers.Time.minute = 0;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 4, 62, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Raphael');
    $gameTemp.reserveCutscene('raphael_second_date');
    return true;
  }

  static checkCutsceneRaphaelWantingGirlfriend(mapId) {
    if (Switches.playedRaphaelWantingGirlfriend) return false;
    if (mapId !== Maps.ORANGE_TOWN) return false;
    if ($gameMap._mapId != Maps.FARM) return false;
    if ($gamePlayer.isRiding()) return false;

    if (!Managers.Time.isBetweenTimes('09:05', '10:30')) return false;

    if (!Managers.Relationship.isCharacterKnown('Raphael')) return false;
    if (!Managers.Relationship.isCharacterKnown('Devin')) return false;
    if (!Switches.unlockedRaphaelEvents) return false;

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 7, 44, Direction.DOWN, 0, false);
    Switches.hidePlayer = true;

    //Reserve the cutscene
    $gameTemp.reserveCutscene('raphael_tells_devin_about_wanting_a_girlfriend_scene');

    return true;
  }

  static checkEventOldHorseCart(mapId) {
    if (Switches.playedOldHorseCartEvent) return;
    if (Switches.canPlayOldHorseCartEvent) return;

    if (!Managers.Relationship.isCharacterKnown('Viktor')) return;
    if (!Switches.unlockedRaphaelEvents) return false;

    if (Managers.History.daysSinceCutscene('raphael_tells_devin_about_wanting_a_girlfriend_scene') < 5) return;

    Switches.canPlayOldHorseCartEvent = true;
  }

}

Managers.Content.registerContentClass(RaphaelContent);