const Scene_ShopItemList = require('game/scenes/shops/ShopList');

let dailyContainer;

class Scene_SalesmanShop extends Scene_ShopItemList {
  makeItemList() {
    this._container.clear();

    const container = GameScenes.SalesmanShop.getSalesmanContainer();
    const data = container.getData();
    this._container.setData(data);
  }

  static initializeDailyContainer() {
    if (!dailyContainer) {
      dailyContainer = new Engine.ItemContainer();
    }

    const possibleItems = [];
    const expensiveItems = [];

    for (let item of $dataItems) {
      if (!item) continue;
      if (item.disabled) continue;
      if (item.ignoredBySalesman) continue;
      if (item.buyPrice < 2) continue;
      if (item.category == 'tools') continue;
      if (item.ingredients) continue;

      const shipped = Managers.History.getShippedItems(item.id);
      if (shipped > 0) {
        possibleItems.push(item.id);
      }

      if (item.buyPrice >= 10000) {
        expensiveItems.push(item.id);
      }
    }

    const chosenItems = [];

    while (chosenItems.length < 12 && possibleItems.length > 0) {
      const idx = Math.randomInt(possibleItems.length);
      chosenItems.push(possibleItems[idx]);
      possibleItems.splice(idx, 1);
    }

    const oldLen = chosenItems.length;
    while (chosenItems.length < oldLen + 2 && expensiveItems.length > 0) {
      const idx = Math.randomInt(expensiveItems.length);
      chosenItems.push(expensiveItems[idx]);
      expensiveItems.splice(idx, 1);
    }

    for (let itemId of chosenItems) {
      dailyContainer.gainItemId(itemId);
    }

    if (dailyContainer.countItems() === 0) {
      dailyContainer.gainItemId('orange');
    }
  }

  static getSalesmanContainer() {
    if (!dailyContainer || dailyContainer.countItems() === 0) {
      GameScenes.SalesmanShop.initializeDailyContainer();
    }

    return dailyContainer;
  }

  static clearSalesmanContainer() {
    dailyContainer = null;
  }
}

GameScenes.SalesmanShop = Scene_SalesmanShop;
module.exports = Scene_SalesmanShop;