require('game/managers/Content');

const Prince = require('./Prince');

class PrinceContent {
  static contentId() {
    return 'prince';
  }

  static processNewDay() {
    Switches.salesmanVisitedToday = false;

    GameScenes.SalesmanShop.clearSalesmanContainer();
  }

  static checkCutscenes(mapId) {
    if (Switches.salesmanVisitedToday) return false;
    if (Managers.Time.weekDay != Days.SATURDAY) return false;
    if (Managers.Time.hour < 6) return false;
    if (Managers.Time.hour >= 18) return false;

    if (mapId !== Maps.FARM) return false;
    if (!$gameMap.isHome()) return false;
    if ($gameTemp.isCutsceneReserved()) return false;

    if (Switches.expandedHouse) {
      if (this.checkCutsceneKitchenUtensils(mapId)) return true;
    }

    return false;
  }

  static makeSaveContents(contents) {
    const container = GameScenes.SalesmanShop.getSalesmanContainer();
    
    contents.salesmanItems = container.getData();
  }

  static extractSaveContents(contents) {
    if (!contents.salesmanItems) {
      return;
    }

    const container = GameScenes.SalesmanShop.getSalesmanContainer();
    if (container) {
      container.setData(contents.salesmanItems);
    }
  }

  static checkCutsceneKitchenUtensils(mapId) {
    var validUtensils = [];
    if (!Switches.hasKitchenKnife) {
      validUtensils.push('knife');
    }
    if (!Switches.hasKitchenPot) {
      validUtensils.push('pot');
    }
    if (!Switches.hasKitchenPan) {
      validUtensils.push('pan');
    }
    if (!Switches.hasKitchenOven) {
      validUtensils.push('oven');
    }
    if (!Switches.hasKitchenMixer) {
      validUtensils.push('mixer');
    }
    if (!Switches.hasKitchenBlender) {
      validUtensils.push('blender');
    }

    if (!Switches.gotSalesmanGoldenOrange) {
      if (validUtensils.length === 0) {
        //Only offer the orange on the first day of the month
        if (Managers.Time.day <= 7) {
          validUtensils.push('golden_orange');
        }
      }
    }

    if (validUtensils.length === 0) return false;
    var idx = Math.randomInt(validUtensils.length);
    var eventName = 'prince_offer_' + validUtensils[idx];

    Switches.salesmanVisitedToday = true;
    $gameTemp.reserveCutscene(eventName);
    return true;
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'prince') return;

    if (Managers.Time.weekDay == Days.SATURDAY && !Switches.isFestival) {
      return 'saturday';
    }
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'PRINCE') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Prince', parser.interpreter);
          Prince.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(PrinceContent);