require('game/managers/Content');

const Pom = require('./Pom');

class PomContent {
  static contentId() {
    return 'pom';
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'pom') return;
    if (!Switches.martinLeftTheCave) return 'task';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'POM') {
      return;
    }

    if (parser.upperName === 'CHAT') {
      const methods = Managers.Villagers.buildContextChatMethods('Pom', parser.interpreter);
      Pom.chat(methods);
      return true;
    }
  }
}

Managers.Content.registerContentClass(PomContent);
