const BaseVillager = require('../_system/BaseVillager');

class Phi extends BaseVillager {
  static getVillagerName() {
    return 'Phi';
  }

  static validMaps() {
    return [
      Maps.CLINIC,
      Maps.ORANGE_TOWN,
      Maps.RESTAURANT
    ];
  }

  static openDoor() {
    $gameMap.openVillagerDoor('Bonnie');
  }

  static closeDoor() {
    $gameMap.closeVillagerDoor('Bonnie');
  }

  static chat(methods) {
    const { play, playOneDayPerWeek } = methods;
    // #ToDo: Companion

    if (Switches.isCandyFestival && !Switches.gaveCandyToPhi) {
      return play('phi_candy_day');
    }

    if (Switches.heardAboutMissingBlueBoots) {
      if (!Switches.deliveredLeftBoot) {
        if (Managers.Items.numItemsById('left-blue-boot') > 0) {
          if (!Switches.deliveredRightBoot &&  Managers.Items.numItemsById('right-blue-boot') > 0) {
            return play('phi_player_has_both_boots');
          }

          return play('phi_player_has_left_boot_only');
        }
      } else if (!Switches.deliveredRightBoot) {
        if (Managers.Items.numItemsById('right-blue-boot') > 0) {
          return play('phi_player_has_right_boot_only');
        }
      }
    } else if (Managers.Time.totalDays > 10) {
      return play('phi_missing_blue_boots');
    }

    if (Managers.Time.yearDay == Festivals.CANDY - 2) {
      return play('phi_candy_day_day_after_tomorrow');
    }

    if (Managers.Time.yearDay == Festivals.CANDY - 1) {
      return play('phi_candy_day_tomorrow');
    }

    if (playOneDayPerWeek('phi_forgot_wallet')) return;
    if (playOneDayPerWeek('phi_horse')) return;
    if (playOneDayPerWeek('phi_flowers_on_the_farm')) return;
    if (playOneDayPerWeek('phi_weekly_saturday')) return;

    return play('phi_default');
  }
}

Phi.register();
module.exports = Phi;
