const Phi = require('./Phi');

class PhiContent {
  static contentId() {
    return 'phi';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'PHI') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Phi.openDoor();
        return true;
      case 'CLOSEDOOR':
        Phi.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Phi', parser.interpreter);
          Phi.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(PhiContent);