require('game/objects/CustomEvent');

Objects.HulaHooping = class HulaHooping extends Objects.CustomEvent {
  update() {
    super.update();

    this._lockPattern = true;

    if (this._animationTimeOut === undefined) {
      this._animationTimeOut = Utils.getFrameCount(10);
      return;
    }

    if (!this._animationTimeOut) {
      this.nextDanceFrame();
      return;
    }

    this._animationTimeOut--;
  }

  nextDanceFrame() {
    const frameLength = 6;

    const allFrames = [
      { index: 0, direction: 2, pattern: 0, frameLength },
      { index: 0, direction: 2, pattern: 1, frameLength },
      { index: 0, direction: 2, pattern: 2, frameLength },
      { index: 0, direction: 2, pattern: 3, frameLength },
      { index: 0, direction: 2, pattern: 4, frameLength },
      { index: 0, direction: 2, pattern: 5, frameLength },
      { index: 0, direction: 2, pattern: 6, frameLength },
    ];

    let currentFrame = this._currentFrame || 0;

    let nextFrame = currentFrame + 1;
    if (nextFrame >= allFrames.length) {
      nextFrame = 0;
    }

    this._currentFrame = nextFrame;
    const frameData = allFrames[nextFrame];
    this._characterIndex = frameData.index;
    this._direction = frameData.direction;
    this._pattern = frameData.pattern;

    this._animationTimeOut = Utils.getFrameCount(frameData.frameLength);
  }
};
