const BaseVillager = require('../_system/BaseVillager');

class Nathalia extends BaseVillager {
  static getVillagerName() {
    return 'Nathalia';
  }

  static validMaps() {
    return [
      Maps.LIBRARY,
      Maps.ORANGE_TOWN,
      Maps.RESTAURANT
    ];
  }

  static checkIfVillagerShouldLeaveParty() {
    // if (Managers.Time.isBetweenTimes('10:30', '19:10')) {
    //   Managers.CommonEvent.playEvent('nathalia_leave_party_to_work');
    //   return;
    // }

    if (Managers.Time.isBetweenTimes('23:30', '23:59') || Managers.Time.isBetweenTimes('00:00', '05:59')) {
      Managers.CommonEvent.playEvent('nathalia_leave_party_to_sleep');
      return;
    }
  }

  static chat(methods) {
    const { play, playOnceADay, playDuringOneDayOnly, playOnePerWeekDay, playOneDayPerMonth } = methods;
    // #ToDo: Companion

    const sequentialChats = () => {
      if (!Switches.unlockedNathaliaEvents) {
        if (playDuringOneDayOnly('nathalia_sequential_1')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_2')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_3')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_4')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_5')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_6')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_7')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_8')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_9')) return true;
        if (playDuringOneDayOnly('nathalia_sequential_10')) return true;
        Switches.unlockedNathaliaEvents = true;
      }
      return false;
    };

    if (sequentialChats()) return;

    if (Managers.Time.yearDay == Festivals.CANDY - 2) {
      if (playOnceADay('nathalia_candy_day_day_after_tomorrow')) return;
    }

    if (Managers.Time.yearDay == Festivals.CANDY - 1) {
      return play('nathalia_candy_day_tomorrow');
    }

    if (Switches.isCandyFestival && !Switches.gaveCandyToNathalia) {
      return play('nathalia_candy_day');
    }

    if (Managers.Relationship.metToday('Nathalia')) {
      if (playOneDayPerMonth(['nathalia_1', 'nathalia_2', 'nathalia_3', 'nathalia_4'])) return;
    }

    if (playOnePerWeekDay(
      [
        'nathalia_weekly_sunday',
        'nathalia_weekly_monday',
        'nathalia_weekly_tuesday',
        'nathalia_weekly_wednesday',
        'nathalia_weekly_thursday',
        'nathalia_weekly_friday',
        'nathalia_weekly_saturday'
      ])) {
      return;
    }

    return play('raphael_default');
  }
}

Nathalia.register();
module.exports = Nathalia;
