const Nathalia = require('./Nathalia');

class NathaliaContent {
  static contentId() {
    return 'nathalia';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'NATHALIA') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Nathalia.openDoor();
        return true;
      case 'CLOSEDOOR':
        Nathalia.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Nathalia', parser.interpreter);
          Nathalia.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Nathalia') return;

    return true;
  }

  static checkCutscenes(mapId) {
    if ($gamePlayer.isRiding()) return false;
    if (!Managers.Relationship.isCharacterKnown('Nathalia')) return false;
    if (!Switches.unlockedNathaliaEvents) return false;

    if (this.checkCutsceneNathaliaDate1(mapId)) return true;
    if (this.checkCutsceneNathaliaDate2(mapId)) return true;
    
    return false;
  }

  static checkCutsceneNathaliaDate1(mapId) {
    if (Switches.playedNathaliaFirstDate) return false;
    if (!Switches.unlockedNathaliaEvents) return false;
    
    if (mapId !== Maps.RESTAURANT) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (Managers.Time.weekDay < Days.FRIDAY || Managers.Time.weekDay > Days.SATURDAY) return false;

    if (!$gameParty.isVillagerOnParty('Nathalia')) return false;
    if (Managers.Time.hour < 17) return false;
    if (Managers.Time.hour >= 20) return false;
    if (Managers.Relationship.getHeartsNum('Nathalia') < 2) return false;

    Managers.Time.hour = 20;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 7, 15, Direction.RIGHT, 0, false);
    $gameParty.removeVillager('Nathalia');
    $gameTemp.reserveCutscene('nathalia_first_date');
    return true;
  }

  static checkCutsceneNathaliaDate2(mapId) {
    if (Switches.playedNathaliaSecondDate) return false;
    if (!Switches.playedNathaliaFirstDate) return false;
    if (!Switches.unlockedNathaliaEvents) return false;

    if (mapId !== Maps.FOREST) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Nathalia')) return false;
    if (Managers.Time.hour < 13) return false;
    if (Managers.Time.hour >= 18) return false;
    if (Managers.Relationship.getHeartsNum('Nathalia') < 3) return false;

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 4, 62, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Nathalia');
    $gameTemp.reserveCutscene('nathalia_second_date');
    return true;
  }

}

Managers.Content.registerContentClass(NathaliaContent);