const BaseVillager = require('../_system/BaseVillager');

class Mia extends BaseVillager {
  static getVillagerName() {
    return 'Mia';
  }

  static validMaps() {
    return [
      Maps.MIAS_HOUSE
    ];
  }

  static chat(methods) {
    const { play, playOneDayPerWeek } = methods;

    if (!Switches.miaExplainedVet) {
      return play('mia_explain_shop');
    }

    if (Switches.talkingOnHouseDoor && !Switches.skipMapStore) {
      return play('mia_shop');
    }

    if (playOneDayPerWeek('mia_talk_to_animals')) return;

    return play('mia_default');
  }

  static retrieveAnAnimal() {
    const play = (eventName) => Managers.Villagers.playDialogue('Mia', eventName);

    const animalsOnCamp = Managers.Creatures._creatures[Maps.ANIMAL_CAMP];
    if (!animalsOnCamp || !animalsOnCamp.length) {
      return play('mia_no_animals_on_camp');
    }

    Managers.Scenes.snapForBackground();
    Managers.Scenes.push(GameScenes.AnimalsToRetrieve);
  }

  static sendAnAnimal() {
    const play = (eventName) => Managers.Villagers.playDialogue('Mia', eventName);

    const animalsToSend = Managers.Creatures.getAnimalsForCampList();
    if (!animalsToSend || !animalsToSend.length) {
      const animalsOnCamp = Managers.Creatures._creatures[Maps.ANIMAL_CAMP];
      if (animalsOnCamp && animalsOnCamp.length) {
        return play('mia_animals_already_on_camp');
      }

      return play('mia_no_animals_to_send');
    }

    Managers.Scenes.snapForBackground();
    Managers.Scenes.push(GameScenes.AnimalsToSend);
  }
}

Mia.register();
module.exports = Mia;
