const Mia = require('./Mia');

class MiaContent {
  static contentId() {
    return 'mia';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'MIA') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'RETRIEVE':
        Mia.retrieveAnAnimal();
        return true;
      case 'SEND':
        Mia.sendAnAnimal();
        return true;
      case 'OPENDOOR':
        Mia.openDoor();
        return true;
      case 'CLOSEDOOR':
        Mia.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Mia', parser.interpreter);
          Mia.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(MiaContent);