const BaseVillager = require('../_system/BaseVillager');
class Martin extends BaseVillager {
  static getVillagerName() {
    return 'Martin';
  }

  static validMaps() {
    return [
      Maps.MAIN_MINE,
      Maps.MOUNTAIN,
      Maps.ORANGE_TOWN,
      Maps.BLACKSMITH,
      Maps.RESTAURANT,
    ];
  }

  static chat(methods) {
    const { play } = methods;

    if (!Switches.martinLeftTheCave) {
      if (Managers.Items._specialItem && Managers.Items._specialItem.id == 'pom') {
        return play('martin_found_pom');
      } else {
        return play('martin_dog_missing');
      }
    }

    if ($gameMap._mapId === Maps.BLACKSMITH) {
      return play('martin_shop');
    }
  
    if ($gameMap._mapId === Maps.ORANGE_TOWN) {
      if (Managers.Time.hour <= 8) {
        return play('martin_going_to_blacksmith');
      } else {
        return play('martin_going_to_restaurant');
      }
    }

    if ($gameMap._mapId === Maps.MOUNTAIN) {
      return play('martin_early_morning');
    }

    if ($gameMap._mapId === Maps.RESTAURANT) {
      return play('martin_at_the_restaurant');
    }

    return play('martin_default');
  }
}

Martin.register();
module.exports = Martin;