require('game/managers/Content');

const Martin = require('./Martin');

class MartinContent {
  static contentId() {
    return 'martin';
  }

  static getCurrentSchedule(villagerName) {
    if (villagerName.toLowerCase() != 'martin') return;
    if (!Switches.martinLeftTheCave) return 'pom';
    if (!Switches.martinCameBack) return;

    if (Managers.Time.weekDay == Days.TUESDAY) {
      return 'tuesday';
    }
  }

  static processNewDay() {
    if (Switches.martinLeftTheCave && !Switches.martinCameBack) {
      Switches.martinCameBack = true;
    }
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'MARTIN') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Martin', parser.interpreter);
          Martin.chat(methods);
        }
        return true;
    }
  }
}

Managers.Content.registerContentClass(MartinContent);
