const BaseVillager = require('../_system/BaseVillager');

class Lucas extends BaseVillager {
  static getVillagerName() {
    return 'Lucas';
  }

  static validMaps() {
    return [
      Maps.ORANGE_TOWN,
      Maps.LUCAS_HOUSE,
      Maps.GENERAL_STORE
    ];
  }

  static chat(methods) {
    const { play, playOnceADay, playOneDayPerWeek, playDuringOneDayOnly } = methods;
    // #ToDo: Companion

    // Lucas' day:
    // Stays awake until 3AM
    // Wakes up after 11AM
    // Goes out at 2pm to buy stuff from the store
    // Gets back home by 5pm

    // #ToDo: Make him leave his house at night to fish

    const coldChats = () => {
      // Lucas is a bit cold on the first few days that you talk to him
      if (!Switches.lucasOpenedUp) {
        if (playDuringOneDayOnly('lucas_cold_door_talk_1')) return true;
        if (playDuringOneDayOnly('lucas_cold_door_talk_2')) return true;
        if (playDuringOneDayOnly('lucas_cold_door_talk_3')) return true;
        if (playDuringOneDayOnly('lucas_cold_door_talk_4')) return true;
        Switches.lucasOpenedUp = true;
      }
    };

    const homeChats = () => {
      if (coldChats()) return true;

      if (Switches.isCandyFestival && Managers.Time.isBetweenTimes('06:00', '18:59')) {
        return play('lucas_candy_day');
      }

      if (Switches.canBuyRoosterFromLucas && !Switches.boughtRoosterFromLucas) {
        return play('lucas_offer_to_sell_rooster');
      }

      if (Managers.Time.isBetweenTimes('11:22', '12:29')) {
        if (playOneDayPerWeek('lucas_just_woke_up')) return true;
      }

      if (playDuringOneDayOnly('lucas_regular_door_talk_1')) return true;
    };

    if (Managers.Time.isBetweenTimes('03:13', '11:21')) {
      // He's actually asleep at this time, so something went wrong anyway
      return play('lucas_default');
    }

    // At home
    if (Managers.Time.isBetweenTimes('11:22', '14:09')) {
      if (homeChats()) return;
    }

    if (Switches.canBuyRoosterFromLucas && !Switches.boughtRoosterFromLucas) {
      if (playOnceADay('lucas_offer_to_sell_rooster')) return;
      if (Utils.whatever()) {
        return play('lucas_offer_to_sell_rooster');
      }
    }

    // Going to the store
    if (Managers.Time.isBetweenTimes('14:10', '15:26')) {
      if (!Switches.lucasOpenedUp) {
        return play('lucas_default');
      }

      if (playOneDayPerWeek('lucas_going_to_store_talk_1')) return;
      if (playOneDayPerWeek('lucas_going_to_store_talk_2')) return;
      if (playOneDayPerWeek('lucas_going_to_store_talk_3')) return;

    }

    // Going back home
    if (Managers.Time.isBetweenTimes('15:57', '17:17')) {
      if (Managers.Time.weekDay == Days.SATURDAY) {
        if (playOneDayPerWeek('lucas_saturday_chat_1')) return;
      }

      if (playOneDayPerWeek('lucas_random_chat_1')) return;
      if (playOneDayPerWeek('lucas_random_chat_2')) return;
      if (playOneDayPerWeek('lucas_random_chat_3')) return;
      if (playOneDayPerWeek('lucas_complain_about_eating_1')) return;
      if (playOneDayPerWeek('lucas_new_toy_1')) return;

    }

    // At home
    if (Managers.Time.isBetweenTimes('17:18', '23:59')) {
      if (homeChats()) return;
    }

    // Still awake at home
    if (Managers.Time.isBetweenTimes('00:00', '03:12')) {
      if (coldChats()) return true;

      // #ToDo: move this to his fishing time
      if (playOneDayPerWeek('lucas_fishing_1')) return;
    }

    return play('lucas_default');
  }
}

Lucas.register();
module.exports = Lucas;
