const Lucas = require('./Lucas');

class LucasContent {
  static contentId() {
    return 'lucas';
  }

  //------------------------------------------------------
  //---- HOOKS
  //------------------------------------------------------  
  static checkCutscenes(mapId) {
    if (!Managers.Relationship.isCharacterKnown('Lucas')) return false;
    if ($gamePlayer.isRiding()) return false;

    if (this.checkCutsceneFishingRod(mapId)) return true;
    if (this.checkCutsceneLucasDate1(mapId)) return true;
    if (this.checkCutsceneLucasDate2(mapId)) return true;

    return false;
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'LUCAS') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Lucas.openDoor();
        return true;
      case 'CLOSEDOOR':
        Lucas.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Lucas', parser.interpreter);
          Lucas.chat(methods);
        }
        return true;
    }
  }

  static callContextChat(villagerName, methods) {
    if (villagerName !== 'Lucas') return;

    Lucas.chat(methods);
    return true;
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Lucas') return;

    return true;

    // if (!Managers.Time.isBetweenTimes('09:00', '20:59')) {
    //   return false;
    // }
  }

  static parseConditionCommand(parser, command, args) {
    if (command.toUpperCase() === 'PREPARELUCASROOSTER') {
      this.prepareRoosterCreature();
      return true;
    }
  }

  static getLetterList() {
    if (!Managers.Relationship.isCharacterKnown('Lucas')) return [];

    if (Managers.Time.totalDays > 20) {
      if (!Switches.startedLucasChickenQuest && !Switches.ignoredLucasChickenQuest) {
        if (!Managers.Creatures.hasAnyCreatureOfRace('rooster')) {
          Switches.startedLucasChickenQuest = true;
          return ['mailbox_lucas_chicken_introduction'];
        } else {
          Switches.ignoredLucasChickenQuest = true;
        }
      }
    }

    if (Switches.startedLucasChickenQuest && !Switches.canBuyRoosterFromLucas) {
      if (Managers.History.daysSinceEvent('completed-task-feeding-lucas-rooster') >= 5) {
        return ['mailbox_lucas_offer_to_sell_rooster'];
      }
    }

    return [];
  }

  //------------------------------------------------------
  //---- OWN METHODS  
  //------------------------------------------------------  
  static prepareRoosterCreature() {
    let creatureType = 'rooster';
    if (Variables.roosterIndex > 0 && Variables.roosterIndex < 8) {
      creatureType += (Variables.roosterIndex + 1);
    }

    const data = Managers.Creatures.prepareCoopCreature(creatureType);
    data.creatureName = 'Gilbert';

    Managers.Achievements.checkAchievements();
    return data;    
  }

  static checkCutsceneFishingRod(mapId) {
    if ($gameParty.hasCompanion()) return false;
    if (Switches.hasFishingRod) return false;
    if (!Switches.lucasOpenedUp) return false;
    if (Switches.lucasGaveCrystal) return false;
    if (mapId !== Maps.FARM) return false;
    if (!$gameMap.isHome()) return false;
    if (Managers.Time.totalDays < 12) return false;
    // if (Managers.Time.hour < 12) return false;

    $gameTemp.reserveCutscene('lucas_fishing_rod');
    return true;
  }

  static checkCutsceneLucasDate1(mapId) {
    if (Switches.playedLucasFirstDate) return false;
    if (!Switches.lucasOpenedUp) return false;

    if (mapId !== Maps.MOUNTAIN) return false;
    if ($gameMap._mapId != Maps.ORANGE_TOWN) return false;

    if (!$gameParty.isVillagerOnParty('Lucas')) return false;
    if (Managers.Time.hour < 10) return false;
    if (Managers.Time.hour >= 15) return false;
    if (Managers.Relationship.getHeartsNum('Lucas') < 2) return false;

    Managers.Time.hour = 15;
    Managers.Time.minute = 3;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 70, 73, Direction.LEFT, 0, false);
    $gameParty.removeVillager('Lucas');
    $gameTemp.reserveCutscene('lucas_first_date');
    return true;
  }

  static checkCutsceneLucasDate2(mapId) {
    if (Switches.playedLucasSecondDate) return false;
    if (!Switches.playedLucasFirstDate) return false;
    if (!Switches.lucasOpenedUp) return false;

    if (mapId !== Maps.BEACH) return false;
    if ($gameMap._mapId != Maps.PETTING_ZOO) return false;

    if (!$gameParty.isVillagerOnParty('Lucas')) return false;
    if (Managers.Time.hour < 20) return false;
    if (Managers.Time.hour >= 23) return false;
    if (Managers.Relationship.getHeartsNum('Lucas') < 3) return false;

    Managers.Time.hour = 23;
    Managers.Time.minute = 0;
    Managers.Time.seconds = 0;
    Managers.Time.updateTime();

    // //Overrides the transfer data with fixed player position for the cutscene
    $gamePlayer.reserveTransfer(mapId, 10, 20, Direction.DOWN, 0, false);
    $gameParty.removeVillager('Lucas');
    $gameTemp.reserveCutscene('lucas_second_date');
    return true;
  }
}

Managers.Content.registerContentClass(LucasContent);
