const BaseVillager = require('../_system/BaseVillager');

class Karl extends BaseVillager {
  static getVillagerName() {
    return 'Karl';
  }

  static validMaps() {
    return [
      Maps.KARLS_HOUSE,
      Maps.ORANGE_TOWN,
      Maps.FOREST
    ];
  }

  static chat(methods) {
    const { play, playOnePerWeekDay } = methods;
    // #ToDo: Companion

    if (playOnePerWeekDay(
      [
        'karl_weekly_sunday',
        'karl_weekly_monday',
        'karl_weekly_tuesday',
        'karl_weekly_wednesday',
        'karl_weekly_thursday',
        'karl_weekly_friday',
        'karl_weekly_saturday'
      ])) {
      return;
    }

    return play('karl_default');
  }
}

Karl.register();
module.exports = Karl;
