const Karl = require('./Karl');

class KarlContent {
  static contentId() {
    return 'karl';
  }

  static parsePluginCommand(parser, command, args) {
    if (command.toUpperCase() !== 'KARL') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Karl.openDoor();
        return true;
      case 'CLOSEDOOR':
        Karl.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Karl', parser.interpreter);
          Karl.chat(methods);
        }
        return true;
    }
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Karl') return;

    return false;
  }
}

Managers.Content.registerContentClass(KarlContent);