const BaseVillager = require('../_system/BaseVillager');

class Julia extends BaseVillager {
  static getVillagerName() {
    return 'Julia';
  }

  static validMaps() {
    return [
      Maps.CITY_HALL,
      Maps.ORANGE_TOWN,
      Maps.BENJAMINS_HOUSE,
      Maps.BRITTANYS_FARM
    ];
  }

  static checkIfVillagerShouldLeaveParty() {
    if (Managers.Time.isBetweenTimes('09:00', '19:10')) {
      Managers.CommonEvent.playEvent('julia_leave_party_to_work');
      return;
    }

    if (Managers.Time.isBetweenTimes('21:20', '23:59') || Managers.Time.isBetweenTimes('00:00', '05:59')) {
      Managers.CommonEvent.playEvent('julia_leave_party_to_sleep');
      return;
    }
  }

  static _chatFestivalConversations(methods) {
    const { play } = methods;

    if (Managers.Time.yearDay === Festivals.CANDY - 1) {
      return play('julia_candy_day_tomorrow');
    }

    if (Managers.Time.yearDay === Festivals.CANDY) {
      return play('julia_candy_day');
    }
  }

  static _chatDefaultSchedule(methods) {
    const { play, playBestEvent, playOneDayPerWeek } = methods;

    if (Managers.Time.hour < 6) {
      return play('julia_default');
    }

    // At home
    if (Managers.Time.isBetweenTimes('06:00', '06:43')) {
      return playBestEvent([
        'julia_early_morning',
        'julia_early_morning_2',
      ]);
    }

    // Going to meet Nathalia
    if (Managers.Time.isBetweenTimes('06:44', '07:15')) {
      return play('julia_going_to_meet_nathalia');
    }

    // With Nathalia
    if (Managers.Time.isBetweenTimes('07:16', '08:20')) {
      if (playOneDayPerWeek(
        [
          'julia_with_nathalia_1',
          'julia_with_nathalia_2',
          // 'julia_with_nathalia_3',
        ])) {
        return true;
      }
    }

    // Going home
    if (Managers.Time.isBetweenTimes('08:21', '08:52')) {
      if (playOneDayPerWeek(
        [
          'julia_going_home_morning_1',
          // 'julia_going_home_morning_2',
          // 'julia_going_home_morning_3',
        ])) {
        return true;
      }
    }

    // At work
    if (Managers.Time.isBetweenTimes('08:53', '16:22')) {
      return playBestEvent([
        'julia_confirm_benji_tutorial',
        'julia_happy_you_moved_in',
        'julia_farmers_meeting',
        'julia_summoning_brittany',
        'julia_at_work_1',
      ]);
    }

    // Going to Brittany's
    if (Managers.Time.isBetweenTimes('16:23', '18:35')) {
      if (playOneDayPerWeek(
        [
          'julia_walking_around_town',
          // 'julia_going_to_brittany_1',
          // 'julia_going_to_brittany_2',
          // 'julia_going_to_brittany_3',
        ])) {
        return true;
      }
    }

    // With Brittany
    if (Managers.Time.isBetweenTimes('18:36', '19:36')) {
      if (playOneDayPerWeek(
        [
          'julia_with_brittany_1',
          // 'julia_with_brittany_2',
          // 'julia_with_brittany_3',
        ])) {
        return true;
      }
    }

    // Going home
    if (Managers.Time.isBetweenTimes('19:37', '21:49')) {
      if (playOneDayPerWeek(
        [
          'julia_walking_around_town',
          'julia_going_home_night_1',
          // 'julia_going_home_night_2',
          // 'julia_going_home_night_3',
        ])) {
        return true;
      }
    }

    // At home
    if (Managers.Time.isBetweenTimes('21:50', '22:13')) {
      if (playOneDayPerWeek(
        [
          'julia_late_night_1',
          // 'julia_late_night_2',
          // 'julia_late_night_3',
        ])) {
        return true;
      }
    }

    // Asleep
    if (Managers.Time.isBetweenTimes('22:14', '23:59')) {
      return play('julia_default');
    }
  }

  static chat(methods) {
    const { play } = methods;
    // #ToDo: Companion

    if (Julia._chatFestivalConversations(methods)) {
      return true;
    }

    const schedule = Managers.Villagers.getCurrentSchedule('Julia');
    const chatFn = {
      default: Julia._chatDefaultSchedule,
    }[schedule] || Julia._chatDefaultSchedule;

    if (chatFn(methods)) {
      return true;
    }

    return play('julia_default');
  }
}

Julia.register();
module.exports = Julia;
