const Julia = require('./Julia');

function generateTownWeeds() {
  const addWeed = (x, y) => {
    if (Managers.FarmObjects.isTileUsed(Maps.ORANGE_TOWN, x, y)) {
      return;
    }

    Managers.FarmObjects.createWeedObjectAt(Maps.ORANGE_TOWN, x, y);
  };

  // Remove every other weed
  Managers.FarmObjects.removeModelNameOnMap(Maps.ORANGE_TOWN, FarmObjectState.WEED);

  addWeed(18, 17);
  addWeed(7, 24);
  addWeed(8, 43);
  addWeed(6, 47);
  addWeed(1, 60);
  addWeed(33, 74);
  addWeed(53, 74);
  addWeed(62, 71);
  addWeed(68, 63);
  addWeed(46, 46);
  addWeed(29, 30);
  addWeed(31, 9);
  addWeed(38, 20);
  addWeed(71, 69);
  addWeed(70, 47);
  addWeed(53, 20);
  addWeed(26, 13);
  addWeed(36, 53);
  addWeed(37, 65);
  addWeed(61, 60);
}

function generateTownLogs() {
  const addLog = (x, y) => {
    if (Managers.FarmObjects.isTileUsed(Maps.ORANGE_TOWN, x, y)) {
      return;
    }

    Managers.FarmObjects.createLogObjectAt(Maps.ORANGE_TOWN, x, y);
  };

  // Remove every other log
  Managers.FarmObjects.removeModelNameOnMap(Maps.ORANGE_TOWN, FarmObjectState.LOG);

  addLog(8, 47);
  addLog(4, 28);
  addLog(9, 26);
  addLog(24, 13);
  addLog(58, 30);
  addLog(74, 57);
  addLog(62, 64);
  addLog(40, 73);
}

function generateTownRocks() {
  const addRock = (x, y) => {
    if (Managers.FarmObjects.isTileUsed(Maps.ORANGE_TOWN, x, y)) {
      return;
    }

    Managers.FarmObjects.createStoneObjectAt(Maps.ORANGE_TOWN, x, y);
  };

  // Remove every other rock
  Managers.FarmObjects.removeModelNameOnMap(Maps.ORANGE_TOWN, FarmObjectState.STONE);

  addRock(3, 26);
  addRock(1, 59);
  addRock(27, 74);
  addRock(44, 74);
  addRock(65, 63);
  addRock(56, 45);
  addRock(25, 28);
  addRock(19, 23);
}

class JuliaContent {
  static contentId() {
    return 'julia';
  }

  static parsePluginCommand(parser, command, args) {
    const exceptions = [
      // Area blocked by lake
      { minX: 6, maxX: 13, minY: 50, maxY: 53, },
      // Rory's Farm
      { minX: 34, maxX: 50, minY: 25, maxY: 31 },
      // Brittany's Farm
      { minX: 22, maxX: 34, minY: 52, maxY: 70 },
      { minX: 6, maxX: 20, minY: 55, maxY: 69 },

    ];

    if (command.toLowerCase() === 'clean_town_task_check_progress') {
      if (Managers.Time.month == Seasons.WINTER) {
        // Pretend it never happened
        Managers.Tasks.setTaskStatus('clean-the-town', TaskStatus.NONE);
        Managers.History.eraseCutsceneRecord('visitor_julia_clean_town_task');

        Managers.CommonEvent.includeChild('clean_town_winter_arrived', parser.interpreter);
        return true;
      }

      Variables.weedsLeft = Managers.FarmObjects.countModelNameOnMap(Maps.ORANGE_TOWN, FarmObjectState.WEED, exceptions);

      if (Variables.weedsLeft > 0) {
        Managers.CommonEvent.includeChild('clean_town_task_incomplete', parser.interpreter);
      } else {
        Managers.CommonEvent.includeChild('clean_town_task_complete', parser.interpreter);
      }
      return true;
    }

    if (command.toLowerCase() === 'clean_logs_check_progress') {
      Variables.logsLeft = Managers.FarmObjects.countModelNameOnMap(Maps.ORANGE_TOWN, FarmObjectState.LOG, exceptions);

      if (Variables.logsLeft > 0) {
        Managers.CommonEvent.includeChild('clean_logs_task_incomplete', parser.interpreter);
      } else {
        Managers.CommonEvent.includeChild('clean_logs_task_complete', parser.interpreter);
      }

      return true;
    }

    if (command.toLowerCase() === 'clean_rocks_check_progress') {
      Variables.rocksLeft = Managers.FarmObjects.countModelNameOnMap(Maps.ORANGE_TOWN, FarmObjectState.STONE, exceptions);

      if (Variables.rocksLeft > 0) {
        Managers.CommonEvent.includeChild('clean_rocks_task_incomplete', parser.interpreter);
      } else {
        Managers.CommonEvent.includeChild('clean_rocks_task_complete', parser.interpreter);
      }

      return true;
    }

    if (command.toUpperCase() === 'TOWN' && parser.name.toUpperCase() === 'GENERATE') {
      const objectToGenerate = parser.nextUpperArg(true);

      switch(objectToGenerate) {
        case 'WEEDS':
          generateTownWeeds();
          return true;
        case 'LOGS':
          generateTownLogs();
          return true;
        case 'ROCKS':
          generateTownRocks();
          return true;
      }

      return;
    }

    if (command.toUpperCase() !== 'JULIA') {
      return;
    }

    switch(parser.name.toUpperCase()) {
      case 'OPENDOOR':
        Julia.openDoor();
        return true;
      case 'CLOSEDOOR':
        Julia.closeDoor();
        return true;
      case 'CHAT':
        {
          const methods = Managers.Villagers.buildContextChatMethods('Julia', parser.interpreter);
          Julia.chat(methods);
        }
        return true;
    }
  }

  static registerGift(villagerName, itemId) {
    if (Managers.Tasks.getTaskStatus('gift-someone') !== TaskStatus.ACCEPTED) {
      return;
    }

    $gameSystem.runWhenAvailable(() => {
      Managers.Tasks.completeTaskAnimation('gift-someone');
    });
  }

  static isVillagerAvailableToHangOut(villagerName) {
    if (villagerName !== 'Julia') return;

    if (Managers.Time.isBetweenTimes('08:53', '16:22')) {
      return false;
    }

    if (Managers.Time.isBetweenTimes('21:20', '23:59')) {
      return false;
    }

    if (Managers.Time.hour < 6) {
      return false;
    }

    return true;
  }
}

Managers.Content.registerContentClass(JuliaContent);