const BaseVillager = require('../_system/BaseVillager');

class Ilda extends BaseVillager {
  static getVillagerName() {
    return 'Ilda';
  }

  static validMaps() {
    return [
      Maps.ORANGE_TOWN,
      Maps.RESTAURANT
    ];
  }

  static _chatDefaultSchedule(methods) {
    const { play, playBestEvent } = methods;

    if (Managers.Time.hour < 7) {
      return play('ilda_default');
    }

    // At home
    if (Managers.Time.isBetweenTimes('07:00', '12:14')) {
      if (Managers.Time.hour < 11) {
        return playBestEvent([
          'ilda_morning',
          'ilda_morning_2',
        ]);
      } else {
        return play('ilda_morning');
      }
    }

    // Going to the restaurant
    if (Managers.Time.isBetweenTimes('12:15', '12:52')) {
      return play('ilda_going_to_restaurant');
    }

    // In the restaurant
    if (Managers.Time.isBetweenTimes('12:53', '14:52')) {
      return play('ilda_restaurant');
    }

    // Going home
    if (Managers.Time.isBetweenTimes('14:53', '15:30')) {
      return play('ilda_going_home');
    }

    // At home
    if (Managers.Time.isBetweenTimes('15:31', '20:59')) {
      if (Managers.Time.hour >= 19) {
        return play('ilda_night');
      }

      return playBestEvent([
        'ilda_random',
      ]);
    }

    return play('ilda_default');
  }

  static _chatRainSchedule(methods) {
    const { play } = methods;

    if (Managers.Weather.isRaining()) {
      return play('ilda_raining');
    }

    return play('ilda_bad_weather');
  }

  static _chatMondaySchedule(methods) {
    const { play } = methods;

    // Receiving flowers from Amanda
    if (Managers.Time.isBetweenTimes('10:48', '11:11')) {
      return play('ilda_receiving_flowers');
    }

    // At home
    if (Managers.Time.isBetweenTimes('11:12', '11:14')) {
      return play('ilda_going_to_cemetery');
    }

    // Going to the cemetery
    if (Managers.Time.isBetweenTimes('11:15', '11:38')) {
      return play('ilda_going_to_cemetery');
    }

    // By her husband's grave
    if (Managers.Time.isBetweenTimes('11:39', '12:20')) {
      return play('ilda_at_husband_grave');
    }

    return Ilda._chatDefaultSchedule(methods);
  }

  static chat(methods) {
    const { play } = methods;
    // #ToDo: Companion

    const schedule = Managers.Villagers.getCurrentSchedule('Ilda');
    const chatFn = {
      default: Ilda._chatDefaultSchedule,
      monday: Ilda._chatMondaySchedule,
      raining: Ilda._chatRainSchedule,
    }[schedule] || Ilda._chatDefaultSchedule;

    if (chatFn(methods)) {
      return true;
    }

    return play('ilda_default');
  }
}

Ilda.register();
module.exports = Ilda;
